/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.utils;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.views.interfaces.ClipView;

public class ClipHelper
implements ClipView {
    private static final Matrix tmpMatrix = new Matrix();
    private final View view;
    private boolean isClipping;
    private final RectF clipRect = new RectF();
    private float clipRotation;
    private final RectF clipBounds = new RectF();
    private final RectF clipBoundsOld = new RectF();

    public ClipHelper(@NonNull View view) {
        this.view = view;
    }

    @Override
    public void clipView(@Nullable RectF rect, float rotation) {
        if (rect == null) {
            if (this.isClipping) {
                this.isClipping = false;
                this.view.invalidate();
            }
        } else {
            if (this.isClipping) {
                this.clipBoundsOld.set(this.clipBounds);
            } else {
                this.clipBoundsOld.set(0.0f, 0.0f, (float)this.view.getWidth(), (float)this.view.getHeight());
            }
            this.isClipping = true;
            this.clipRect.set(rect);
            this.clipRotation = rotation;
            this.clipBounds.set(this.clipRect);
            if (!State.equals(rotation, 0.0f)) {
                tmpMatrix.setRotate(rotation, this.clipRect.centerX(), this.clipRect.centerY());
                tmpMatrix.mapRect(this.clipBounds);
            }
            int left = (int)Math.min(this.clipBounds.left, this.clipBoundsOld.left);
            int top = (int)Math.min(this.clipBounds.top, this.clipBoundsOld.top);
            int right = (int)Math.max(this.clipBounds.right, this.clipBoundsOld.right) + 1;
            int bottom = (int)Math.max(this.clipBounds.bottom, this.clipBoundsOld.bottom) + 1;
            this.view.invalidate(left, top, right, bottom);
        }
    }

    public void onPreDraw(@NonNull Canvas canvas) {
        if (this.isClipping) {
            canvas.save();
            if (State.equals(this.clipRotation, 0.0f)) {
                canvas.clipRect(this.clipRect);
            } else {
                canvas.rotate(this.clipRotation, this.clipRect.centerX(), this.clipRect.centerY());
                canvas.clipRect(this.clipRect);
                canvas.rotate(-this.clipRotation, this.clipRect.centerX(), this.clipRect.centerY());
            }
        }
    }

    public void onPostDraw(@NonNull Canvas canvas) {
        if (this.isClipping) {
            canvas.restore();
        }
    }
}

