/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.transition.internal;

import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import com.alexvasilkov.gestures.animation.ViewPositionAnimator;
import com.alexvasilkov.gestures.transition.ViewsTransitionAnimator;
import com.alexvasilkov.gestures.transition.tracker.IntoTracker;
import com.alexvasilkov.gestures.views.interfaces.AnimatorView;

public class IntoViewPagerListener<ID>
extends ViewsTransitionAnimator.RequestListener<ID> {
    private final ViewPager viewPager;
    private final IntoTracker<ID> tracker;
    private boolean preventExit;

    public IntoViewPagerListener(ViewPager viewPager, IntoTracker<ID> tracker) {
        this.viewPager = viewPager;
        this.tracker = tracker;
        viewPager.setVisibility(8);
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new PagerListener());
        viewPager.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)new ChildStateListener());
    }

    @Override
    protected void initAnimator(ViewsTransitionAnimator<ID> animator) {
        super.initAnimator(animator);
        animator.addPositionUpdateListener(new ViewPositionAnimator.PositionUpdateListener(){

            @Override
            public void onPositionUpdate(float pos, boolean isLeaving) {
                if (pos == 1.0f && isLeaving && IntoViewPagerListener.this.getAnimator().getRequestedId() != null) {
                    if (IntoViewPagerListener.this.preventExit) {
                        IntoViewPagerListener.this.skipExit();
                    }
                    IntoViewPagerListener.this.switchToCurrentPage();
                }
                IntoViewPagerListener.this.viewPager.setVisibility(pos == 0.0f && isLeaving ? 4 : 0);
            }
        });
    }

    @Override
    public void onRequestView(@NonNull ID id) {
        int position;
        if (this.viewPager.getVisibility() == 8) {
            this.viewPager.setVisibility(4);
        }
        if ((position = this.tracker.getPositionById(id)) == -1) {
            return;
        }
        if (this.viewPager.getCurrentItem() == position) {
            this.applyCurrentPage();
        } else {
            this.viewPager.setCurrentItem(position, false);
        }
    }

    private void applyCurrentPage() {
        Object id = this.getAnimator().getRequestedId();
        if (id == null) {
            return;
        }
        if (this.viewPager.getAdapter() == null || this.viewPager.getAdapter().getCount() == 0) {
            return;
        }
        int position = this.tracker.getPositionById(id);
        if (position == -1) {
            this.switchToCurrentPage();
            return;
        }
        if (position != this.viewPager.getCurrentItem()) {
            return;
        }
        View view = this.tracker.getViewById(id);
        if (view instanceof AnimatorView) {
            this.getAnimator().setToView(id, (AnimatorView)view);
        } else if (view != null) {
            throw new IllegalArgumentException("View for " + id + " should be AnimatorView");
        }
    }

    private void switchToCurrentPage() {
        if (this.viewPager.getAdapter() == null || this.viewPager.getAdapter().getCount() == 0) {
            return;
        }
        Object id = this.getAnimator().getRequestedId();
        ID currentId = this.tracker.getIdByPosition(this.viewPager.getCurrentItem());
        if (id != null && currentId != null && !id.equals(currentId)) {
            AnimatorView toView = this.getAnimator().getToView();
            ViewPositionAnimator toAnimator = toView == null ? null : toView.getPositionAnimator();
            boolean isLeaving = toAnimator != null && toAnimator.isLeaving();
            float position = toAnimator == null ? 0.0f : toAnimator.getPosition();
            boolean isAnimating = toAnimator != null && toAnimator.isAnimating();
            this.skipExit();
            this.getAnimator().enter(currentId, false);
            if (isLeaving && position > 0.0f) {
                this.getAnimator().exit(isAnimating);
            }
        }
    }

    private void skipExit() {
        ViewPositionAnimator toAnimator;
        if (this.getAnimator().getToView() != null && (toAnimator = this.getAnimator().getToView().getPositionAnimator()).isLeaving() && toAnimator.getPosition() == 1.0f) {
            toAnimator.setState(1.0f, false, false);
        }
    }

    private class ChildStateListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ChildStateListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            IntoViewPagerListener.this.applyCurrentPage();
        }

        public void onChildViewRemoved(View parent, View child) {
        }
    }

    private class PagerListener
    implements ViewPager.OnPageChangeListener {
        private PagerListener() {
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            IntoViewPagerListener.this.applyCurrentPage();
        }

        public void onPageScrollStateChanged(int state) {
            IntoViewPagerListener.this.preventExit = state == 1 && !IntoViewPagerListener.this.getAnimator().isLeaving();
            if (state == 0 && IntoViewPagerListener.this.getAnimator().getRequestedId() != null) {
                IntoViewPagerListener.this.switchToCurrentPage();
            }
        }
    }
}

