/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.transition.internal;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.view.View;
import com.alexvasilkov.gestures.animation.ViewPositionAnimator;
import com.alexvasilkov.gestures.transition.ViewsTransitionAnimator;
import com.alexvasilkov.gestures.transition.tracker.FromTracker;

abstract class FromBaseListener<P extends View, ID>
extends ViewsTransitionAnimator.RequestListener<ID> {
    private static final Rect locationParent = new Rect();
    private static final Rect locationChild = new Rect();
    private final P parentView;
    private final FromTracker<ID> tracker;
    private final boolean autoScroll;
    private boolean isFullyOpened;

    FromBaseListener(P parentView, FromTracker<ID> tracker, boolean autoScroll) {
        this.parentView = parentView;
        this.tracker = tracker;
        this.autoScroll = autoScroll;
    }

    abstract boolean isShownInList(P var1, int var2);

    abstract void scrollToPosition(P var1, int var2);

    @Override
    protected void initAnimator(ViewsTransitionAnimator<ID> animator) {
        super.initAnimator(animator);
        animator.addPositionUpdateListener(new ViewPositionAnimator.PositionUpdateListener(){

            @Override
            public void onPositionUpdate(float pos, boolean isLeaving) {
                FromBaseListener.this.parentView.setVisibility(pos == 1.0f && !isLeaving ? 4 : 0);
                FromBaseListener.this.isFullyOpened = pos == 1.0f;
            }
        });
    }

    @Override
    public void onRequestView(@NonNull ID id) {
        int position = this.tracker.getPositionById(id);
        if (position == -1) {
            this.getAnimator().setFromNone(id);
            return;
        }
        if (this.isShownInList(this.parentView, position)) {
            View view = this.tracker.getViewById(id);
            if (view == null) {
                this.getAnimator().setFromNone(id);
            } else {
                this.getAnimator().setFromView(id, view);
                if (this.autoScroll && this.isFullyOpened && !FromBaseListener.isFullyVisible(this.parentView, view)) {
                    this.scrollToPosition(this.parentView, position);
                }
            }
        } else {
            this.getAnimator().setFromNone(id);
            if (this.autoScroll) {
                this.scrollToPosition(this.parentView, position);
            }
        }
    }

    private static boolean isFullyVisible(View parent, View child) {
        parent.getGlobalVisibleRect(locationParent);
        FromBaseListener.locationParent.left += parent.getPaddingLeft();
        FromBaseListener.locationParent.right -= parent.getPaddingRight();
        FromBaseListener.locationParent.top += parent.getPaddingTop();
        FromBaseListener.locationParent.bottom -= parent.getPaddingBottom();
        child.getGlobalVisibleRect(locationChild);
        return locationParent.contains(locationChild) && child.getWidth() == locationChild.width() && child.getHeight() == locationChild.height();
    }
}

