/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.transition;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.alexvasilkov.gestures.animation.ViewPosition;
import com.alexvasilkov.gestures.animation.ViewPositionAnimator;
import com.alexvasilkov.gestures.internal.GestureDebug;
import com.alexvasilkov.gestures.transition.ViewsCoordinator;
import com.alexvasilkov.gestures.views.interfaces.AnimatorView;
import java.util.ArrayList;
import java.util.List;

public class ViewsTransitionAnimator<ID>
extends ViewsCoordinator<ID> {
    private static final Object NONE = new Object();
    private static final String TAG = ViewsTransitionAnimator.class.getSimpleName();
    private final List<ViewPositionAnimator.PositionUpdateListener> listeners = new ArrayList<ViewPositionAnimator.PositionUpdateListener>();
    private boolean enterWithAnimation;
    private boolean isEntered;
    private boolean exitRequested;
    private boolean exitWithAnimation;

    @Deprecated
    public ViewsTransitionAnimator() {
        this.addPositionUpdateListener(new ViewPositionAnimator.PositionUpdateListener(){

            @Override
            public void onPositionUpdate(float position, boolean isLeaving) {
                if (position == 0.0f && isLeaving) {
                    ViewsTransitionAnimator.this.cleanupRequest();
                }
            }
        });
    }

    public void enter(@NonNull ID id, boolean withAnimation) {
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Enter requested for " + id + ", with animation = " + withAnimation));
        }
        this.enterWithAnimation = withAnimation;
        this.request(id);
    }

    public void enterSingle(boolean withAnimation) {
        this.enter(NONE, withAnimation);
    }

    public void exit(boolean withAnimation) {
        if (this.getRequestedId() == null) {
            throw new IllegalStateException("You should call enter(...) before calling exit(...)");
        }
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Exit requested from " + this.getRequestedId() + ", with animation = " + withAnimation));
        }
        this.exitRequested = true;
        this.exitWithAnimation = withAnimation;
        this.exitIfRequested();
    }

    private void exitIfRequested() {
        if (this.exitRequested && this.isReady()) {
            this.exitRequested = false;
            if (GestureDebug.isDebugAnimator()) {
                Log.d((String)TAG, (String)("Perform exit from " + this.getRequestedId()));
            }
            this.getToView().getPositionAnimator().exit(this.exitWithAnimation);
        }
    }

    public boolean isLeaving() {
        return this.exitRequested || this.getRequestedId() == null || this.isReady() && this.getToView().getPositionAnimator().isLeaving();
    }

    public void addPositionUpdateListener(@NonNull ViewPositionAnimator.PositionUpdateListener listener) {
        this.listeners.add(listener);
        if (this.isReady()) {
            this.getToView().getPositionAnimator().addPositionUpdateListener(listener);
        }
    }

    public void removePositionUpdateListener(@NonNull ViewPositionAnimator.PositionUpdateListener listener) {
        this.listeners.remove(listener);
        if (this.isReady()) {
            this.getToView().getPositionAnimator().removePositionUpdateListener(listener);
        }
    }

    @Override
    public void setFromListener(@NonNull ViewsCoordinator.OnRequestViewListener<ID> listener) {
        super.setFromListener(listener);
        if (listener instanceof RequestListener) {
            ((RequestListener)listener).initAnimator(this);
        }
    }

    @Override
    public void setToListener(@NonNull ViewsCoordinator.OnRequestViewListener<ID> listener) {
        super.setToListener(listener);
        if (listener instanceof RequestListener) {
            ((RequestListener)listener).initAnimator(this);
        }
    }

    @Override
    protected void onFromViewChanged(@Nullable View fromView, @Nullable ViewPosition fromPos) {
        super.onFromViewChanged(fromView, fromPos);
        if (this.isReady()) {
            if (GestureDebug.isDebugAnimator()) {
                Log.d((String)TAG, (String)("Updating 'from' view for " + this.getRequestedId()));
            }
            if (fromView != null) {
                this.getToView().getPositionAnimator().update(fromView);
            } else if (fromPos != null) {
                this.getToView().getPositionAnimator().update(fromPos);
            } else {
                this.getToView().getPositionAnimator().updateToNone();
            }
        }
    }

    @Override
    protected void onToViewChanged(@Nullable AnimatorView old, @NonNull AnimatorView view) {
        super.onToViewChanged(old, view);
        if (this.isReady() && old != null) {
            this.swapAnimator(old.getPositionAnimator(), view.getPositionAnimator());
        } else {
            if (old != null) {
                this.cleanupAnimator(old.getPositionAnimator());
            }
            this.initAnimator(view.getPositionAnimator());
        }
    }

    @Override
    protected void onViewsReady(@NonNull ID id) {
        if (!this.isEntered) {
            this.isEntered = true;
            if (GestureDebug.isDebugAnimator()) {
                Log.d((String)TAG, (String)("Ready to enter for " + this.getRequestedId()));
            }
            if (this.getFromView() != null) {
                this.getToView().getPositionAnimator().enter(this.getFromView(), this.enterWithAnimation);
            } else if (this.getFromPos() != null) {
                this.getToView().getPositionAnimator().enter(this.getFromPos(), this.enterWithAnimation);
            } else {
                this.getToView().getPositionAnimator().enter(this.enterWithAnimation);
            }
            this.exitIfRequested();
        }
        if (this.getFromView() instanceof ImageView && this.getToView() instanceof ImageView) {
            ImageView from = (ImageView)this.getFromView();
            ImageView to = (ImageView)this.getToView();
            if (to.getDrawable() == null) {
                to.setImageDrawable(from.getDrawable());
            }
        }
        super.onViewsReady(id);
    }

    @Override
    protected void cleanupRequest() {
        if (this.getToView() != null) {
            this.cleanupAnimator(this.getToView().getPositionAnimator());
        }
        this.isEntered = false;
        this.exitRequested = false;
        super.cleanupRequest();
    }

    private void initAnimator(ViewPositionAnimator animator) {
        for (ViewPositionAnimator.PositionUpdateListener listener : this.listeners) {
            animator.addPositionUpdateListener(listener);
        }
    }

    private void cleanupAnimator(ViewPositionAnimator animator) {
        for (ViewPositionAnimator.PositionUpdateListener listener : this.listeners) {
            animator.removePositionUpdateListener(listener);
        }
        if (!animator.isLeaving() || animator.getPosition() != 0.0f) {
            if (GestureDebug.isDebugAnimator()) {
                Log.d((String)TAG, (String)("Exiting from cleaned animator for " + this.getRequestedId()));
            }
            animator.exit(false);
        }
    }

    private void swapAnimator(ViewPositionAnimator old, ViewPositionAnimator next) {
        float position = old.getPosition();
        boolean isLeaving = old.isLeaving();
        boolean isAnimating = old.isAnimating();
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Swapping animator for " + this.getRequestedId()));
        }
        this.cleanupAnimator(old);
        if (this.getFromView() != null) {
            next.enter(this.getFromView(), false);
        } else if (this.getFromPos() != null) {
            next.enter(this.getFromPos(), false);
        }
        this.initAnimator(next);
        next.setState(position, isLeaving, isAnimating);
    }

    public static abstract class RequestListener<ID>
    implements ViewsCoordinator.OnRequestViewListener<ID> {
        private ViewsTransitionAnimator<ID> animator;

        protected void initAnimator(ViewsTransitionAnimator<ID> animator) {
            this.animator = animator;
        }

        protected ViewsTransitionAnimator<ID> getAnimator() {
            return this.animator;
        }
    }
}

