/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.transition;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import com.alexvasilkov.gestures.animation.ViewPosition;
import com.alexvasilkov.gestures.internal.GestureDebug;
import com.alexvasilkov.gestures.views.interfaces.AnimatorView;

public class ViewsCoordinator<ID> {
    private static final String TAG = ViewsCoordinator.class.getSimpleName();
    private OnRequestViewListener<ID> fromListener;
    private OnRequestViewListener<ID> toListener;
    private OnViewsReadyListener<ID> readyListener;
    private ID requestedId;
    private ID fromId;
    private ID toId;
    private View fromView;
    private ViewPosition fromPos;
    private AnimatorView toView;

    public void setFromListener(@NonNull OnRequestViewListener<ID> listener) {
        this.fromListener = listener;
    }

    public void setToListener(@NonNull OnRequestViewListener<ID> listener) {
        this.toListener = listener;
    }

    public void setReadyListener(@Nullable OnViewsReadyListener<ID> listener) {
        this.readyListener = listener;
    }

    public void request(@NonNull ID id) {
        if (this.fromListener == null) {
            throw new RuntimeException("'from' listener is not set");
        }
        if (this.toListener == null) {
            throw new RuntimeException("'to' listener is not set");
        }
        this.cleanupRequest();
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Requesting " + id));
        }
        this.requestedId = id;
        this.fromListener.onRequestView(id);
        this.toListener.onRequestView(id);
    }

    public ID getRequestedId() {
        return this.requestedId;
    }

    public View getFromView() {
        return this.fromView;
    }

    public ViewPosition getFromPos() {
        return this.fromPos;
    }

    public AnimatorView getToView() {
        return this.toView;
    }

    public void setFromView(@NonNull ID id, @NonNull View fromView) {
        this.setFromInternal(id, fromView, null);
    }

    public void setFromPos(@NonNull ID id, @NonNull ViewPosition fromPos) {
        this.setFromInternal(id, null, fromPos);
    }

    public void setFromNone(@NonNull ID id) {
        this.setFromInternal(id, null, null);
    }

    private void setFromInternal(@NonNull ID id, View fromView, ViewPosition fromPos) {
        if (this.requestedId == null || !this.requestedId.equals(id)) {
            return;
        }
        if (this.fromView == fromView && fromView != null) {
            return;
        }
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Setting 'from' view for " + id));
        }
        this.onFromViewChanged(fromView, fromPos);
        this.fromId = id;
        this.fromView = fromView;
        this.fromPos = fromPos;
        this.notifyWhenReady();
    }

    protected void onFromViewChanged(@Nullable View fromView, @Nullable ViewPosition fromPos) {
    }

    public void setToView(@NonNull ID id, @NonNull AnimatorView toView) {
        if (this.requestedId == null || !this.requestedId.equals(id)) {
            return;
        }
        if (this.toView == toView) {
            return;
        }
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Setting 'to' view for " + id));
        }
        this.onToViewChanged(this.toView, toView);
        this.toId = id;
        this.toView = toView;
        this.notifyWhenReady();
    }

    protected void onToViewChanged(@Nullable AnimatorView old, @NonNull AnimatorView view) {
    }

    public boolean isReady() {
        return this.requestedId != null && this.requestedId.equals(this.fromId) && this.requestedId.equals(this.toId);
    }

    private void notifyWhenReady() {
        if (this.isReady()) {
            this.onViewsReady(this.requestedId);
        }
    }

    protected void onViewsReady(@NonNull ID id) {
        if (this.readyListener != null) {
            this.readyListener.onViewsReady(id);
        }
    }

    protected void cleanupRequest() {
        if (this.requestedId == null) {
            return;
        }
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Cleaning up request " + this.requestedId));
        }
        this.fromView = null;
        this.fromPos = null;
        this.toView = null;
        this.toId = null;
        this.fromId = null;
        this.requestedId = null;
    }

    public static interface OnViewsReadyListener<ID> {
        public void onViewsReady(@NonNull ID var1);
    }

    public static interface OnRequestViewListener<ID> {
        public void onRequestView(@NonNull ID var1);
    }
}

