/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.transition;

import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ListView;
import com.alexvasilkov.gestures.transition.ViewsTransitionAnimator;
import com.alexvasilkov.gestures.transition.internal.FromListViewListener;
import com.alexvasilkov.gestures.transition.internal.FromRecyclerViewListener;
import com.alexvasilkov.gestures.transition.internal.IntoViewPagerListener;
import com.alexvasilkov.gestures.transition.tracker.FromTracker;
import com.alexvasilkov.gestures.transition.tracker.IntoTracker;
import com.alexvasilkov.gestures.views.interfaces.AnimatorView;

public class GestureTransitions<ID> {
    private final ViewsTransitionAnimator<ID> animator = new ViewsTransitionAnimator();

    private GestureTransitions() {
    }

    public static <ID> GestureTransitions<ID> from(@NonNull ViewsTransitionAnimator.RequestListener<ID> listener) {
        GestureTransitions<ID> builder = new GestureTransitions<ID>();
        builder.animator.setFromListener(listener);
        return builder;
    }

    public static <ID> GestureTransitions<ID> from(final @NonNull View view) {
        return GestureTransitions.from(new ViewsTransitionAnimator.RequestListener<ID>(){

            @Override
            public void onRequestView(@NonNull ID id) {
                this.getAnimator().setFromView(id, view);
            }
        });
    }

    public static <ID> GestureTransitions<ID> from(@NonNull RecyclerView recyclerView, @NonNull FromTracker<ID> tracker) {
        return GestureTransitions.from(recyclerView, tracker, true);
    }

    public static <ID> GestureTransitions<ID> from(@NonNull RecyclerView recyclerView, @NonNull FromTracker<ID> tracker, boolean autoScroll) {
        return GestureTransitions.from(new FromRecyclerViewListener<ID>(recyclerView, tracker, autoScroll));
    }

    public static <ID> GestureTransitions<ID> from(@NonNull ListView listView, @NonNull FromTracker<ID> tracker) {
        return GestureTransitions.from(listView, tracker, true);
    }

    public static <ID> GestureTransitions<ID> from(@NonNull ListView listView, @NonNull FromTracker<ID> tracker, boolean autoScroll) {
        return GestureTransitions.from(new FromListViewListener<ID>(listView, tracker, autoScroll));
    }

    public static <ID> GestureTransitions<ID> fromNone() {
        return GestureTransitions.from(new ViewsTransitionAnimator.RequestListener<ID>(){

            @Override
            public void onRequestView(@NonNull ID id) {
                this.getAnimator().setFromNone(id);
            }
        });
    }

    public ViewsTransitionAnimator<ID> into(@NonNull ViewsTransitionAnimator.RequestListener<ID> listener) {
        this.animator.setToListener(listener);
        return this.animator;
    }

    public ViewsTransitionAnimator<ID> into(final @NonNull AnimatorView view) {
        return this.into(new ViewsTransitionAnimator.RequestListener<ID>(){

            @Override
            public void onRequestView(@NonNull ID id) {
                this.getAnimator().setToView(id, view);
            }
        });
    }

    public ViewsTransitionAnimator<ID> into(@NonNull ViewPager viewPager, @NonNull IntoTracker<ID> tracker) {
        return this.into(new IntoViewPagerListener<ID>(viewPager, tracker));
    }
}

