/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.internal.detectors;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;

public class ScaleGestureDetectorFixed
extends ScaleGestureDetector {
    private float currY;
    private float prevY;

    public ScaleGestureDetectorFixed(Context context, ScaleGestureDetector.OnScaleGestureListener listener) {
        super(context, listener);
        this.warmUpScaleDetector();
    }

    private void warmUpScaleDetector() {
        long time = System.currentTimeMillis();
        MotionEvent event = MotionEvent.obtain((long)time, (long)time, (int)3, (float)0.0f, (float)0.0f, (int)0);
        this.onTouchEvent(event);
        event.recycle();
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        this.prevY = this.currY;
        this.currY = event.getY();
        if (event.getActionMasked() == 0) {
            this.prevY = event.getY();
        }
        return result;
    }

    @TargetApi(value=19)
    private boolean isInDoubleTapMode() {
        return Build.VERSION.SDK_INT >= 19 && this.isQuickScaleEnabled() && this.getCurrentSpan() == this.getCurrentSpanY();
    }

    public float getScaleFactor() {
        float factor = super.getScaleFactor();
        if (this.isInDoubleTapMode()) {
            return this.currY > this.prevY && factor > 1.0f || this.currY < this.prevY && factor < 1.0f ? Math.max(0.8f, Math.min(factor, 1.25f)) : 1.0f;
        }
        return factor;
    }
}

