/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.internal.detectors;

import android.content.Context;
import android.view.MotionEvent;

public class RotationGestureDetector {
    private static final float ROTATION_SLOP = 5.0f;
    private final OnRotationGestureListener listener;
    private float focusX;
    private float focusY;
    private float initialAngle;
    private float currAngle;
    private float prevAngle;
    private boolean isInProgress;
    private boolean isGestureAccepted;

    public RotationGestureDetector(Context context, OnRotationGestureListener listener) {
        this.listener = listener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: 
            case 1: 
            case 3: {
                this.cancelRotation();
                break;
            }
            case 5: {
                if (event.getPointerCount() != 2) break;
                this.prevAngle = this.currAngle = this.computeRotation(event);
                this.initialAngle = this.currAngle;
                break;
            }
            case 2: {
                boolean isAccepted;
                if (event.getPointerCount() < 2 || this.isInProgress && !this.isGestureAccepted) break;
                this.currAngle = this.computeRotation(event);
                this.focusX = 0.5f * (event.getX(1) + event.getX(0));
                this.focusY = 0.5f * (event.getY(1) + event.getY(0));
                boolean isAlreadyStarted = this.isInProgress;
                this.tryStartRotation();
                boolean bl = isAccepted = !isAlreadyStarted || this.processRotation();
                if (!isAccepted) break;
                this.prevAngle = this.currAngle;
                break;
            }
            case 6: {
                if (event.getPointerCount() != 2) break;
                this.cancelRotation();
                break;
            }
        }
        return true;
    }

    private void tryStartRotation() {
        if (this.isInProgress || Math.abs(this.initialAngle - this.currAngle) < 5.0f) {
            return;
        }
        this.isInProgress = true;
        this.isGestureAccepted = this.listener.onRotationBegin(this);
    }

    private void cancelRotation() {
        if (!this.isInProgress) {
            return;
        }
        this.isInProgress = false;
        if (this.isGestureAccepted) {
            this.listener.onRotationEnd(this);
            this.isGestureAccepted = false;
        }
    }

    private boolean processRotation() {
        return this.isInProgress && this.isGestureAccepted && this.listener.onRotate(this);
    }

    private float computeRotation(MotionEvent event) {
        return (float)Math.toDegrees(Math.atan2(event.getY(1) - event.getY(0), event.getX(1) - event.getX(0)));
    }

    public boolean isInProgress() {
        return this.isInProgress;
    }

    public float getFocusX() {
        return this.focusX;
    }

    public float getFocusY() {
        return this.focusY;
    }

    public float getRotationDelta() {
        return this.currAngle - this.prevAngle;
    }

    public static interface OnRotationGestureListener {
        public boolean onRotate(RotationGestureDetector var1);

        public boolean onRotationBegin(RotationGestureDetector var1);

        public void onRotationEnd(RotationGestureDetector var1);
    }
}

