/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.internal;

import android.graphics.Matrix;
import android.graphics.RectF;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.utils.MathUtils;

public class ZoomBounds {
    private static final Matrix tmpMatrix = new Matrix();
    private static final RectF tmpRectF = new RectF();
    private final Settings settings;
    private float minZoom;
    private float maxZoom;
    private float fitZoom;

    public ZoomBounds(Settings settings) {
        this.settings = settings;
    }

    public ZoomBounds set(State state) {
        float imageWidth = this.settings.getImageW();
        float imageHeight = this.settings.getImageH();
        float areaWidth = this.settings.getMovementAreaW();
        float areaHeight = this.settings.getMovementAreaH();
        if (imageWidth == 0.0f || imageHeight == 0.0f || areaWidth == 0.0f || areaHeight == 0.0f) {
            this.fitZoom = 1.0f;
            this.maxZoom = 1.0f;
            this.minZoom = 1.0f;
            return this;
        }
        this.minZoom = this.settings.getMinZoom();
        this.maxZoom = this.settings.getMaxZoom();
        float rotation = state.getRotation();
        if (!State.equals(rotation, 0.0f)) {
            if (this.settings.getFitMethod() == Settings.Fit.OUTSIDE) {
                tmpMatrix.setRotate(-rotation);
                tmpRectF.set(0.0f, 0.0f, areaWidth, areaHeight);
                tmpMatrix.mapRect(tmpRectF);
                areaWidth = tmpRectF.width();
                areaHeight = tmpRectF.height();
            } else {
                tmpMatrix.setRotate(rotation);
                tmpRectF.set(0.0f, 0.0f, imageWidth, imageHeight);
                tmpMatrix.mapRect(tmpRectF);
                imageWidth = tmpRectF.width();
                imageHeight = tmpRectF.height();
            }
        }
        switch (this.settings.getFitMethod()) {
            case HORIZONTAL: {
                this.fitZoom = areaWidth / imageWidth;
                break;
            }
            case VERTICAL: {
                this.fitZoom = areaHeight / imageHeight;
                break;
            }
            case INSIDE: {
                this.fitZoom = Math.min(areaWidth / imageWidth, areaHeight / imageHeight);
                break;
            }
            case OUTSIDE: {
                this.fitZoom = Math.max(areaWidth / imageWidth, areaHeight / imageHeight);
                break;
            }
            default: {
                float f = this.fitZoom = this.minZoom > 0.0f ? this.minZoom : 1.0f;
            }
        }
        if (this.minZoom <= 0.0f) {
            this.minZoom = this.fitZoom;
        }
        if (this.maxZoom <= 0.0f) {
            this.maxZoom = this.fitZoom;
        }
        if (this.fitZoom > this.maxZoom) {
            if (this.settings.isFillViewport()) {
                this.maxZoom = this.fitZoom;
            } else {
                this.fitZoom = this.maxZoom;
            }
        }
        if (this.minZoom > this.maxZoom) {
            this.minZoom = this.maxZoom;
        }
        if (this.fitZoom < this.minZoom) {
            if (this.settings.isFillViewport()) {
                this.minZoom = this.fitZoom;
            } else {
                this.fitZoom = this.minZoom;
            }
        }
        return this;
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public float getFitZoom() {
        return this.fitZoom;
    }

    public float restrict(float zoom, float extraZoom) {
        return MathUtils.restrict(zoom, this.minZoom / extraZoom, this.maxZoom * extraZoom);
    }
}

