/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.internal;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.utils.GravityUtils;
import com.alexvasilkov.gestures.utils.MathUtils;

public class MovementBounds {
    private static final Matrix tmpMatrix = new Matrix();
    private static final float[] tmpPointArr = new float[2];
    private static final Point tmpPoint = new Point();
    private static final Rect tmpRect = new Rect();
    private static final RectF tmpRectF = new RectF();
    private final Settings settings;
    private final RectF bounds = new RectF();
    private float boundsRotation;
    private float boundsPivotX;
    private float boundsPivotY;

    public MovementBounds(Settings settings) {
        this.settings = settings;
    }

    public MovementBounds set(State state) {
        RectF area = tmpRectF;
        GravityUtils.getMovementAreaPosition(this.settings, tmpRect);
        area.set(tmpRect);
        Rect pos = tmpRect;
        if (this.settings.getFitMethod() == Settings.Fit.OUTSIDE) {
            this.boundsRotation = state.getRotation();
            this.boundsPivotX = area.centerX();
            this.boundsPivotY = area.centerY();
            if (!State.equals(this.boundsRotation, 0.0f)) {
                tmpMatrix.setRotate(-this.boundsRotation, this.boundsPivotX, this.boundsPivotY);
                tmpMatrix.mapRect(area);
            }
        } else {
            this.boundsRotation = 0.0f;
            this.boundsPivotY = 0.0f;
            this.boundsPivotX = 0.0f;
        }
        state.get(tmpMatrix);
        if (!State.equals(this.boundsRotation, 0.0f)) {
            tmpMatrix.postRotate(-this.boundsRotation, this.boundsPivotX, this.boundsPivotY);
        }
        GravityUtils.getImagePosition(tmpMatrix, this.settings, pos);
        switch (this.settings.getBoundsType()) {
            case NORMAL: {
                this.calculateNormalBounds(area, pos);
                break;
            }
            case INSIDE: {
                this.calculateInsideBounds(area, pos);
                break;
            }
            case OUTSIDE: {
                this.calculateOutsideBounds(area, pos);
                break;
            }
            case PIVOT: {
                this.calculatePivotBounds(pos);
                break;
            }
            default: {
                this.bounds.set(-5.368709E8f, -5.368709E8f, 5.368709E8f, 5.368709E8f);
            }
        }
        if (this.settings.getFitMethod() != Settings.Fit.OUTSIDE) {
            state.get(tmpMatrix);
            RectF imageRect = tmpRectF;
            imageRect.set(0.0f, 0.0f, (float)this.settings.getImageW(), (float)this.settings.getImageH());
            tmpMatrix.mapRect(imageRect);
            MovementBounds.tmpPointArr[1] = 0.0f;
            MovementBounds.tmpPointArr[0] = 0.0f;
            tmpMatrix.mapPoints(tmpPointArr);
            this.bounds.offset(tmpPointArr[0] - imageRect.left, tmpPointArr[1] - imageRect.top);
        }
        return this;
    }

    private void calculateNormalBounds(RectF area, Rect pos) {
        if (area.width() < (float)pos.width()) {
            this.bounds.left = area.left - ((float)pos.width() - area.width());
            this.bounds.right = area.left;
        } else {
            this.bounds.left = this.bounds.right = (float)pos.left;
        }
        if (area.height() < (float)pos.height()) {
            this.bounds.top = area.top - ((float)pos.height() - area.height());
            this.bounds.bottom = area.top;
        } else {
            this.bounds.top = this.bounds.bottom = (float)pos.top;
        }
    }

    private void calculateInsideBounds(RectF area, Rect pos) {
        if (area.width() < (float)pos.width()) {
            this.bounds.left = area.left - ((float)pos.width() - area.width());
            this.bounds.right = area.left;
        } else {
            this.bounds.left = area.left;
            this.bounds.right = area.right - (float)pos.width();
        }
        if (area.height() < (float)pos.height()) {
            this.bounds.top = area.top - ((float)pos.height() - area.height());
            this.bounds.bottom = area.top;
        } else {
            this.bounds.top = area.top;
            this.bounds.bottom = area.bottom - (float)pos.height();
        }
    }

    private void calculateOutsideBounds(RectF area, Rect pos) {
        this.bounds.left = area.left - (float)pos.width();
        this.bounds.right = area.right;
        this.bounds.top = area.top - (float)pos.height();
        this.bounds.bottom = area.bottom;
    }

    private void calculatePivotBounds(Rect pos) {
        GravityUtils.getDefaultPivot(this.settings, tmpPoint);
        MovementBounds.tmpPointArr[0] = MovementBounds.tmpPoint.x;
        MovementBounds.tmpPointArr[1] = MovementBounds.tmpPoint.y;
        if (!State.equals(this.boundsRotation, 0.0f)) {
            tmpMatrix.setRotate(-this.boundsRotation, this.boundsPivotX, this.boundsPivotY);
            tmpMatrix.mapPoints(tmpPointArr);
        }
        this.bounds.left = tmpPointArr[0] - (float)pos.width();
        this.bounds.right = tmpPointArr[0];
        this.bounds.top = tmpPointArr[1] - (float)pos.height();
        this.bounds.bottom = tmpPointArr[1];
    }

    public void extend(float x, float y) {
        MovementBounds.tmpPointArr[0] = x;
        MovementBounds.tmpPointArr[1] = y;
        if (this.boundsRotation != 0.0f) {
            tmpMatrix.setRotate(-this.boundsRotation, this.boundsPivotX, this.boundsPivotY);
            tmpMatrix.mapPoints(tmpPointArr);
        }
        this.bounds.union(tmpPointArr[0], tmpPointArr[1]);
    }

    public void getExternalBounds(RectF out) {
        if (this.boundsRotation == 0.0f) {
            out.set(this.bounds);
        } else {
            tmpMatrix.setRotate(this.boundsRotation, this.boundsPivotX, this.boundsPivotY);
            tmpMatrix.mapRect(out, this.bounds);
        }
    }

    public void restrict(float x, float y, float extraX, float extraY, PointF out) {
        MovementBounds.tmpPointArr[0] = x;
        MovementBounds.tmpPointArr[1] = y;
        if (this.boundsRotation != 0.0f) {
            tmpMatrix.setRotate(-this.boundsRotation, this.boundsPivotX, this.boundsPivotY);
            tmpMatrix.mapPoints(tmpPointArr);
        }
        MovementBounds.tmpPointArr[0] = MathUtils.restrict(tmpPointArr[0], this.bounds.left - extraX, this.bounds.right + extraX);
        MovementBounds.tmpPointArr[1] = MathUtils.restrict(tmpPointArr[1], this.bounds.top - extraY, this.bounds.bottom + extraY);
        if (this.boundsRotation != 0.0f) {
            tmpMatrix.setRotate(this.boundsRotation, this.boundsPivotX, this.boundsPivotY);
            tmpMatrix.mapPoints(tmpPointArr);
        }
        out.set(tmpPointArr[0], tmpPointArr[1]);
    }

    public void restrict(float x, float y, PointF out) {
        this.restrict(x, y, 0.0f, 0.0f, out);
    }
}

