/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.internal;

import android.os.SystemClock;
import android.util.Log;
import com.alexvasilkov.gestures.internal.GestureDebug;

class Fps {
    private static final String TAG = "GestureFps";
    private static final long WARNING_TIME = 20L;
    private static final long ERROR_TIME = 40L;
    private long frameStart;
    private long animationStart;
    private int framesCount;

    Fps() {
    }

    void start() {
        if (GestureDebug.isDebugFps()) {
            this.animationStart = this.frameStart = SystemClock.uptimeMillis();
            this.framesCount = 0;
        }
    }

    void stop() {
        if (GestureDebug.isDebugFps() && this.framesCount > 0) {
            int time = (int)(SystemClock.uptimeMillis() - this.animationStart);
            Log.d((String)TAG, (String)("Average FPS: " + Math.round(1000.0f * (float)this.framesCount / (float)time)));
        }
    }

    void step() {
        if (GestureDebug.isDebugFps()) {
            long frameTime = SystemClock.uptimeMillis() - this.frameStart;
            if (frameTime > 40L) {
                Log.e((String)TAG, (String)("Frame time: " + frameTime));
            } else if (frameTime > 20L) {
                Log.w((String)TAG, (String)("Frame time: " + frameTime));
            }
            ++this.framesCount;
            this.frameStart = SystemClock.uptimeMillis();
        }
    }
}

