/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.internal;

import android.graphics.Point;
import android.graphics.RectF;
import android.view.View;
import com.alexvasilkov.gestures.GestureController;
import com.alexvasilkov.gestures.GestureControllerForPager;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.animation.ViewPositionAnimator;
import com.alexvasilkov.gestures.internal.UnitsUtils;
import com.alexvasilkov.gestures.utils.GravityUtils;
import com.alexvasilkov.gestures.utils.MathUtils;
import com.alexvasilkov.gestures.views.interfaces.AnimatorView;

public class ExitController {
    private static final float SCROLL_FACTOR = 0.5f;
    private static final float SCROLL_THRESHOLD = 30.0f;
    private static final float ZOOM_FACTOR = 0.75f;
    private static final float ZOOM_THRESHOLD = 0.75f;
    private static final float EXIT_THRESHOLD = 0.75f;
    private static final float MIN_EXIT_STATE = 0.01f;
    private static final RectF tmpArea = new RectF();
    private static final Point tmpPivot = new Point();
    private final float scrollThresholdScaled;
    private final GestureController controller;
    private final AnimatorView animatorView;
    private float exitState = 1.0f;
    private boolean isZoomInAction;
    private boolean isRotationInAction;
    private boolean skipScrollDetection;
    private boolean skipZoomDetection;
    private boolean isScrollDetected;
    private boolean isZoomDetected;
    private float totalScrollX;
    private float totalScrollY;
    private float zoomAccumulator = 1.0f;
    private float scrollDirection;
    private float initialY;
    private float initialZoom;

    public ExitController(View view, GestureController gestureController) {
        this.controller = gestureController;
        this.animatorView = view instanceof AnimatorView ? (AnimatorView)view : null;
        this.scrollThresholdScaled = UnitsUtils.toPixels(view.getContext(), 30.0f);
    }

    public boolean isExitDetected() {
        return this.isScrollDetected || this.isZoomDetected;
    }

    public void stopDetection() {
        if (this.isExitDetected()) {
            this.exitState = 1.0f;
            this.updateState();
            this.finishDetection();
        }
    }

    public void onUpOrCancel() {
        this.finishDetection();
    }

    public boolean onScroll(float dx, float dy) {
        if (!this.skipScrollDetection && !this.isExitDetected() && this.canDetectExit() && this.canDetectScroll() && !this.canScroll(dy)) {
            this.totalScrollX += dx;
            this.totalScrollY += dy;
            if (Math.abs(this.totalScrollY) > this.scrollThresholdScaled) {
                this.isScrollDetected = true;
                this.initialY = this.controller.getState().getY();
                this.startDetection();
            } else if (Math.abs(this.totalScrollX) > this.scrollThresholdScaled) {
                this.skipScrollDetection = true;
            }
        }
        if (this.isScrollDetected) {
            if (this.scrollDirection == 0.0f) {
                this.scrollDirection = Math.signum(dy);
            }
            if (this.exitState < 0.75f && Math.signum(dy) == this.scrollDirection) {
                dy *= this.exitState / 0.75f;
            }
            float total = this.scrollDirection * 0.5f * (float)Math.max(this.controller.getSettings().getMovementAreaW(), this.controller.getSettings().getMovementAreaH());
            this.exitState = 1.0f - (this.controller.getState().getY() + dy - this.initialY) / total;
            this.exitState = MathUtils.restrict(this.exitState, 0.01f, 1.0f);
            if (this.exitState == 1.0f) {
                this.controller.getState().translateTo(this.controller.getState().getX(), this.initialY);
            } else {
                this.controller.getState().translateBy(0.0f, dy);
            }
            this.updateState();
            if (this.exitState == 1.0f) {
                this.finishDetection();
            }
            return true;
        }
        return this.isExitDetected();
    }

    public boolean onFling() {
        return this.isExitDetected();
    }

    public void onScaleBegin() {
        this.isZoomInAction = true;
    }

    public void onScaleEnd() {
        this.isZoomInAction = false;
        this.skipZoomDetection = false;
        if (this.isZoomDetected) {
            this.finishDetection();
        }
    }

    public boolean onScale(float scaleFactor) {
        if (!this.canDetectZoom()) {
            this.skipZoomDetection = true;
        }
        if (!this.skipZoomDetection && !this.isExitDetected() && this.canDetectExit() && scaleFactor < 1.0f) {
            this.zoomAccumulator *= scaleFactor;
            if (this.zoomAccumulator < 0.75f) {
                this.isZoomDetected = true;
                this.initialZoom = this.controller.getState().getZoom();
                this.startDetection();
            }
        }
        if (this.isZoomDetected) {
            this.exitState = this.controller.getState().getZoom() * scaleFactor / this.initialZoom;
            this.exitState = MathUtils.restrict(this.exitState, 0.01f, 1.0f);
            GravityUtils.getDefaultPivot(this.controller.getSettings(), tmpPivot);
            if (this.exitState == 1.0f) {
                this.controller.getState().zoomTo(this.initialZoom, ExitController.tmpPivot.x, ExitController.tmpPivot.y);
            } else {
                float scaleFactorFixed = 1.0f + (scaleFactor - 1.0f) * 0.75f;
                this.controller.getState().zoomBy(scaleFactorFixed, ExitController.tmpPivot.x, ExitController.tmpPivot.y);
            }
            this.updateState();
            if (this.exitState == 1.0f) {
                this.finishDetection();
                return true;
            }
        }
        return this.isExitDetected();
    }

    public void applyZoomPatch() {
        this.initialZoom = this.controller.getStateController().applyZoomPatch(this.initialZoom);
    }

    public void onRotationBegin() {
        this.isRotationInAction = true;
    }

    public void onRotationEnd() {
        this.isRotationInAction = false;
    }

    public boolean onRotate() {
        return this.isExitDetected();
    }

    private boolean canDetectExit() {
        return this.controller.getSettings().isExitEnabled() && this.animatorView != null && !this.animatorView.getPositionAnimator().isLeaving();
    }

    private boolean canDetectScroll() {
        Settings.ExitType exitType = this.controller.getSettings().getExitType();
        return (exitType == Settings.ExitType.ALL || exitType == Settings.ExitType.SCROLL) && !this.isZoomInAction && !this.isRotationInAction && this.isZoomedOut();
    }

    private boolean canDetectZoom() {
        Settings.ExitType exitType = this.controller.getSettings().getExitType();
        return (exitType == Settings.ExitType.ALL || exitType == Settings.ExitType.ZOOM) && !this.isRotationInAction && this.isZoomedOut();
    }

    private boolean canScroll(float dy) {
        if (!this.controller.getSettings().isRestrictBounds()) {
            return true;
        }
        State state = this.controller.getState();
        this.controller.getStateController().getMovementArea(state, tmpArea);
        return dy > 0.0f && (float)State.compare(state.getY(), ExitController.tmpArea.bottom) < 0.0f || dy < 0.0f && (float)State.compare(state.getY(), ExitController.tmpArea.top) > 0.0f;
    }

    private boolean isZoomedOut() {
        State state = this.controller.getState();
        float minZoom = this.controller.getStateController().getMinZoom(state);
        return State.compare(state.getZoom(), minZoom) <= 0;
    }

    private void startDetection() {
        this.controller.getSettings().disableBounds();
        if (this.controller instanceof GestureControllerForPager) {
            ((GestureControllerForPager)this.controller).disableViewPager(true);
        }
    }

    private void finishDetection() {
        if (this.isExitDetected()) {
            if (this.controller instanceof GestureControllerForPager) {
                ((GestureControllerForPager)this.controller).disableViewPager(false);
            }
            this.controller.getSettings().enableBounds();
            ViewPositionAnimator animator = this.animatorView.getPositionAnimator();
            if (!animator.isAnimating() && this.canDetectExit()) {
                boolean isLeaving;
                float position = animator.getPosition();
                boolean bl = isLeaving = position < 0.75f;
                if (isLeaving) {
                    animator.exit(true);
                } else {
                    boolean isZoomedBack;
                    float y = this.controller.getState().getY();
                    float zoom = this.controller.getState().getZoom();
                    boolean isScrolledBack = this.isScrollDetected && State.equals(y, this.initialY);
                    boolean bl2 = isZoomedBack = this.isZoomDetected && State.equals(zoom, this.initialZoom);
                    if (position < 1.0f) {
                        animator.setState(position, false, true);
                        if (!isScrolledBack && !isZoomedBack) {
                            this.controller.getSettings().enableBounds();
                            this.controller.animateKeepInBounds();
                            this.controller.getSettings().disableBounds();
                        }
                    }
                }
            }
        }
        this.isScrollDetected = false;
        this.isZoomDetected = false;
        this.skipScrollDetection = false;
        this.exitState = 1.0f;
        this.scrollDirection = 0.0f;
        this.totalScrollX = 0.0f;
        this.totalScrollY = 0.0f;
        this.zoomAccumulator = 1.0f;
    }

    private void updateState() {
        if (this.canDetectExit()) {
            this.animatorView.getPositionAnimator().setToState(this.controller.getState(), this.exitState);
            this.animatorView.getPositionAnimator().setState(this.exitState, false, false);
        }
    }
}

