/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.view.View;
import com.alexvasilkov.gestures.GestureController;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.animation.ViewPositionAnimator;
import com.alexvasilkov.gestures.internal.UnitsUtils;
import com.alexvasilkov.gestures.utils.GravityUtils;
import com.alexvasilkov.gestures.views.interfaces.AnimatorView;
import com.alexvasilkov.gestures.views.interfaces.GestureView;
import java.lang.reflect.Field;
import java.util.Locale;

public class DebugOverlay {
    private static final float STROKE_WIDTH = 2.0f;
    private static final float TEXT_SIZE = 16.0f;
    private static final Paint paint = new Paint();
    private static final RectF rectF = new RectF();
    private static final Rect rect = new Rect();
    private static final Matrix matrix = new Matrix();
    private static Field stateSourceField;

    private DebugOverlay() {
    }

    public static void drawDebug(View view, Canvas canvas) {
        GestureController controller = ((GestureView)view).getController();
        ViewPositionAnimator animator = ((AnimatorView)view).getPositionAnimator();
        Settings settings = controller.getSettings();
        Context context = view.getContext();
        float stroke = UnitsUtils.toPixels(context, 2.0f);
        float textSize = UnitsUtils.toPixels(context, 16.0f);
        canvas.save();
        canvas.translate((float)view.getPaddingLeft(), (float)view.getPaddingTop());
        rectF.set(0.0f, 0.0f, (float)settings.getViewportW(), (float)settings.getViewportH());
        DebugOverlay.drawRect(canvas, rectF, -7829368, stroke);
        GravityUtils.getMovementAreaPosition(settings, rect);
        rectF.set(rect);
        DebugOverlay.drawRect(canvas, rectF, -16711936, stroke);
        controller.getState().get(matrix);
        canvas.save();
        canvas.concat(matrix);
        rectF.set(0.0f, 0.0f, (float)settings.getImageW(), (float)settings.getImageH());
        DebugOverlay.drawRect(canvas, rectF, -256, stroke / controller.getState().getZoom());
        canvas.restore();
        rectF.set(0.0f, 0.0f, (float)settings.getImageW(), (float)settings.getImageH());
        controller.getState().get(matrix);
        matrix.mapRect(rectF);
        DebugOverlay.drawRect(canvas, rectF, -65536, stroke);
        float pos = animator.getPosition();
        if (pos == 1.0f || pos == 0.0f && animator.isLeaving()) {
            GestureController.StateSource source = DebugOverlay.getStateSource(controller);
            DebugOverlay.drawText(canvas, settings, source.name(), -16711681, textSize);
            if (source != GestureController.StateSource.NONE) {
                view.invalidate();
            }
        } else if (pos > 0.0f) {
            String direction = animator.isLeaving() ? "EXIT" : "ENTER";
            String text = String.format(Locale.US, "%s %.0f%%", direction, Float.valueOf(pos * 100.0f));
            DebugOverlay.drawText(canvas, settings, text, -65281, textSize);
        }
        canvas.restore();
    }

    private static void drawRect(Canvas canvas, RectF rect, int color, float stroke) {
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(stroke);
        rectF.inset(0.5f * stroke, 0.5f * stroke);
        paint.setColor(color);
        canvas.drawRect(rect, paint);
    }

    private static void drawText(Canvas canvas, Settings settings, String text, int color, float textSize) {
        paint.setTextSize(textSize);
        paint.setTypeface(Typeface.MONOSPACE);
        paint.setTextAlign(Paint.Align.CENTER);
        float halfSize = 0.5f * textSize;
        paint.getTextBounds(text, 0, text.length(), rect);
        rectF.set(rect);
        rectF.offset(-rectF.centerX(), -rectF.centerY());
        GravityUtils.getMovementAreaPosition(settings, rect);
        rectF.offset((float)rect.centerX(), (float)rect.centerY());
        rectF.inset(-halfSize, -halfSize);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(-1);
        canvas.drawRoundRect(rectF, halfSize, halfSize, paint);
        paint.setStyle(Paint.Style.STROKE);
        paint.setColor(-7829368);
        canvas.drawRoundRect(rectF, halfSize, halfSize, paint);
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(color);
        canvas.drawText(text, rectF.centerX(), DebugOverlay.rectF.bottom - halfSize, paint);
    }

    private static GestureController.StateSource getStateSource(GestureController controller) {
        if (stateSourceField == null) {
            try {
                stateSourceField = GestureController.class.getDeclaredField("stateSource");
                stateSourceField.setAccessible(true);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (stateSourceField != null) {
            try {
                return (GestureController.StateSource)((Object)stateSourceField.get(controller));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return GestureController.StateSource.NONE;
    }
}

