/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.internal;

import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import com.alexvasilkov.gestures.internal.Fps;
import com.alexvasilkov.gestures.internal.GestureDebug;

public abstract class AnimationEngine
implements Runnable {
    private static final long FRAME_TIME = 10L;
    private final View view;
    private final Fps fps;

    public AnimationEngine(@NonNull View view) {
        this.view = view;
        this.fps = GestureDebug.isDebugFps() ? new Fps() : null;
    }

    @Override
    public final void run() {
        boolean continueAnimation = this.onStep();
        if (this.fps != null) {
            this.fps.step();
            if (!continueAnimation) {
                this.fps.stop();
            }
        }
        if (continueAnimation) {
            this.scheduleNextStep();
        }
    }

    public abstract boolean onStep();

    private void scheduleNextStep() {
        this.view.removeCallbacks((Runnable)this);
        if (Build.VERSION.SDK_INT >= 16) {
            this.view.postOnAnimationDelayed((Runnable)this, 10L);
        } else {
            this.view.postDelayed((Runnable)this, 10L);
        }
    }

    public void start() {
        if (this.fps != null) {
            this.fps.start();
        }
        this.scheduleNextStep();
    }
}

