/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.commons.circle;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;

public class CircleImageView
extends ImageView {
    private static final int DEFAULT_PAINT_FLAGS = 3;
    private static final Matrix tmpMatrix = new Matrix();
    private Paint bitmapPaint;
    private RectF rect;
    private boolean isCircle;

    public CircleImageView(Context context) {
        this(context, null, 0);
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        if (this.bitmapPaint == null) {
            this.bitmapPaint = new Paint(3);
            this.rect = new RectF();
            this.isCircle = true;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int specWidth = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        int specHeight = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        super.onMeasure(specWidth, specHeight);
    }

    protected boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = super.setFrame(left, top, right, bottom);
        this.rect.set((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()));
        this.setup();
        return changed;
    }

    protected void onDraw(Canvas canvas) {
        this.init();
        if (this.bitmapPaint.getShader() == null) {
            super.onDraw(canvas);
        } else {
            float rx = 0.5f * this.rect.width();
            float ry = 0.5f * this.rect.height();
            canvas.drawRoundRect(this.rect, rx, ry, this.bitmapPaint);
        }
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.setup();
    }

    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.setup();
    }

    public void setImageMatrix(Matrix matrix) {
        super.setImageMatrix(matrix);
        this.setup();
    }

    public void setCircle(boolean isCircle) {
        this.isCircle = isCircle;
        this.setup();
    }

    private void setup() {
        Bitmap bitmap;
        this.init();
        Bitmap bitmap2 = bitmap = this.isCircle ? this.getBitmapFromDrawable(this.getDrawable()) : null;
        if (bitmap != null) {
            BitmapShader bitmapShader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
            tmpMatrix.set(this.getImageMatrix());
            tmpMatrix.postTranslate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            bitmapShader.setLocalMatrix(tmpMatrix);
            this.bitmapPaint.setShader((Shader)bitmapShader);
        } else {
            this.bitmapPaint.setShader(null);
        }
        this.invalidate();
    }

    protected Bitmap getBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        throw new RuntimeException("For better performance only BitmapDrawables are supported, but you can override getBitmapFromDrawable() and build bitmap on your own");
    }
}

