/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.commons.circle;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import com.alexvasilkov.gestures.animation.ViewPositionAnimator;
import com.alexvasilkov.gestures.internal.DebugOverlay;
import com.alexvasilkov.gestures.internal.GestureDebug;
import com.alexvasilkov.gestures.utils.MathUtils;
import com.alexvasilkov.gestures.views.GestureImageView;

public class CircleGestureImageView
extends GestureImageView {
    private static final int DEFAULT_PAINT_FLAGS = 3;
    private static final Matrix tmpMatrix = new Matrix();
    private final Paint bitmapPaint = new Paint(3);
    private final RectF clipRect = new RectF();
    private float clipRotation;
    private boolean isCircle = true;
    private float cornersState;

    public CircleGestureImageView(Context context) {
        this(context, null, 0);
    }

    public CircleGestureImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircleGestureImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.getPositionAnimator().addPositionUpdateListener(new ViewPositionAnimator.PositionUpdateListener(){

            @Override
            public void onPositionUpdate(float position, boolean isLeaving) {
                float interpolatedPosition = position / CircleGestureImageView.this.getPositionAnimator().getToPosition();
                CircleGestureImageView.this.cornersState = MathUtils.restrict(interpolatedPosition, 0.0f, 1.0f);
            }
        });
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        if (this.cornersState == 1.0f || this.clipRect.isEmpty() || this.bitmapPaint.getShader() == null) {
            super.draw(canvas);
        } else {
            float rx = 0.5f * this.clipRect.width() * (1.0f - this.cornersState);
            float ry = 0.5f * this.clipRect.height() * (1.0f - this.cornersState);
            canvas.rotate(this.clipRotation, this.clipRect.centerX(), this.clipRect.centerY());
            canvas.drawRoundRect(this.clipRect, rx, ry, this.bitmapPaint);
            canvas.rotate(-this.clipRotation, this.clipRect.centerX(), this.clipRect.centerY());
            if (GestureDebug.isDrawDebugOverlay()) {
                DebugOverlay.drawDebug((View)this, canvas);
            }
        }
    }

    @Override
    public void clipView(@Nullable RectF rect, float rotation) {
        if (rect == null) {
            this.clipRect.setEmpty();
        } else {
            this.clipRect.set(rect);
        }
        this.clipRotation = rotation;
        this.updateShaderMatrix();
        super.clipView(rect, rotation);
    }

    @Override
    public void setImageDrawable(Drawable drawable) {
        super.setImageDrawable(drawable);
        this.setup();
    }

    public void setCircle(boolean isCircle) {
        this.isCircle = isCircle;
        this.setup();
    }

    public void setImageMatrix(Matrix matrix) {
        super.setImageMatrix(matrix);
        this.updateShaderMatrix();
    }

    private void setup() {
        Bitmap bitmap;
        Bitmap bitmap2 = bitmap = this.isCircle ? this.getBitmapFromDrawable(this.getDrawable()) : null;
        if (bitmap != null) {
            this.bitmapPaint.setShader((Shader)new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP));
            this.updateShaderMatrix();
        } else {
            this.bitmapPaint.setShader(null);
        }
        this.invalidate();
    }

    private void updateShaderMatrix() {
        if (!this.clipRect.isEmpty() && this.bitmapPaint.getShader() != null) {
            this.getController().getState().get(tmpMatrix);
            tmpMatrix.postTranslate((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            tmpMatrix.postRotate(-this.clipRotation, this.clipRect.centerX(), this.clipRect.centerY());
            this.bitmapPaint.getShader().setLocalMatrix(tmpMatrix);
        }
    }

    protected Bitmap getBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        throw new RuntimeException("For better performance only BitmapDrawables are supported, but you can override getBitmapFromDrawable() and build bitmap on your own");
    }
}

