/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.commons;

import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.LinkedList;
import java.util.Queue;

public abstract class RecyclePagerAdapter<VH extends ViewHolder>
extends PagerAdapter {
    private final Queue<VH> cache = new LinkedList<VH>();
    private final SparseArray<VH> attached = new SparseArray();

    public abstract VH onCreateViewHolder(@NonNull ViewGroup var1);

    public abstract void onBindViewHolder(@NonNull VH var1, int var2);

    public void onRecycleViewHolder(@NonNull VH holder) {
    }

    public VH getViewHolder(int position) {
        return (VH)((ViewHolder)this.attached.get(position));
    }

    public Object instantiateItem(ViewGroup container, int position) {
        ViewHolder holder = (ViewHolder)this.cache.poll();
        if (holder == null) {
            holder = this.onCreateViewHolder(container);
        }
        this.attached.put(position, (Object)holder);
        container.addView(holder.itemView, null);
        this.onBindViewHolder(holder, position);
        return holder;
    }

    public void destroyItem(ViewGroup container, int position, Object object) {
        ViewHolder holder = (ViewHolder)object;
        this.attached.remove(position);
        container.removeView(holder.itemView);
        this.cache.offer(holder);
        this.onRecycleViewHolder(holder);
    }

    public boolean isViewFromObject(View view, Object object) {
        ViewHolder holder = (ViewHolder)object;
        return holder.itemView == view;
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public static class ViewHolder {
        public final View itemView;

        public ViewHolder(@NonNull View itemView) {
            this.itemView = itemView;
        }
    }
}

