/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.commons;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.internal.UnitsUtils;
import com.alexvasilkov.gestures.utils.GravityUtils;

@Deprecated
public class FinderView
extends View {
    public static final int DEFAULT_BACK_COLOR = Color.argb((int)128, (int)0, (int)0, (int)0);
    public static final int DEFAULT_BORDER_COLOR = -1;
    public static final float DEFAULT_BORDER_WIDTH = 2.0f;
    private static final Rect tmpRect = new Rect();
    private final RectF rect = new RectF();
    private float rounding = 0.0f;
    private final RectF strokeRect = new RectF();
    private final Paint paintStroke = new Paint();
    private final Paint paintClear = new Paint();
    private int backColor;
    private Settings settings;

    public FinderView(Context context) {
        this(context, null);
    }

    public FinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.paintClear.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.paintClear.setAntiAlias(true);
        this.paintStroke.setStyle(Paint.Style.STROKE);
        this.paintStroke.setAntiAlias(true);
        this.setBackColor(DEFAULT_BACK_COLOR);
        this.setBorderColor(-1);
        this.setBorderWidth(1, 2.0f);
    }

    public void setBackColor(@ColorInt int color) {
        this.backColor = color;
    }

    public void setBorderColor(@ColorInt int color) {
        this.paintStroke.setColor(color);
    }

    public void setBorderWidth(float width) {
        this.paintStroke.setStrokeWidth(width);
    }

    public void setBorderWidth(int unit, float width) {
        this.setBorderWidth(UnitsUtils.toPixels(this.getContext(), unit, width));
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
        this.update();
    }

    public void setRounded(boolean rounded) {
        this.rounding = rounded ? 1.0f : 0.0f;
        this.update();
    }

    public void update(boolean animate) {
        this.update();
    }

    public void update() {
        if (this.settings != null && this.getWidth() > 0 && this.getHeight() > 0) {
            GravityUtils.getMovementAreaPosition(this.settings, tmpRect);
            this.rect.set(tmpRect);
            this.rect.offset((float)this.getPaddingLeft(), (float)this.getPaddingTop());
            this.strokeRect.set(this.rect);
            float halfStroke = 0.5f * this.paintStroke.getStrokeWidth();
            this.strokeRect.inset(-halfStroke, -halfStroke);
            this.invalidate();
        }
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        this.update();
    }

    protected void onDraw(Canvas canvas) {
        float rx = this.rounding * 0.5f * this.rect.width();
        float ry = this.rounding * 0.5f * this.rect.height();
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null);
        } else {
            canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null, 0);
        }
        canvas.drawColor(this.backColor);
        canvas.drawRoundRect(this.rect, rx, ry, this.paintClear);
        canvas.restore();
        canvas.drawRoundRect(this.strokeRect, rx, ry, this.paintStroke);
    }
}

