/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.commons;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import com.alexvasilkov.gestures.R;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.internal.AnimationEngine;
import com.alexvasilkov.gestures.internal.UnitsUtils;
import com.alexvasilkov.gestures.utils.FloatScroller;
import com.alexvasilkov.gestures.utils.GravityUtils;
import com.alexvasilkov.gestures.utils.MathUtils;
import com.alexvasilkov.gestures.views.GestureImageView;

public class CropAreaView
extends View {
    private static final int BACK_COLOR = Color.argb((int)160, (int)0, (int)0, (int)0);
    private static final int BORDER_COLOR = -1;
    private static final float BORDER_WIDTH_DP = 2.0f;
    private static final float NO_ASPECT = 0.0f;
    public static final float ORIGINAL_ASPECT = -1.0f;
    private static final Rect tmpRect = new Rect();
    private static final RectF tmpRectF = new RectF();
    private final RectF areaRect = new RectF();
    private float rounding = 0.0f;
    private final RectF strokeRect = new RectF();
    private final RectF startRect = new RectF();
    private final RectF endRect = new RectF();
    private float startRounding;
    private float endRounding;
    private final Paint paint = new Paint();
    private final Paint paintClear = new Paint();
    private final FloatScroller stateScroller = new FloatScroller();
    private final AnimationEngine animationEngine = new LocalAnimationEngine();
    private int backColor;
    private int borderColor;
    private float borderWidth;
    private int horizontalRules;
    private int verticalRules;
    private float rulesWidth;
    private float aspect;
    private GestureImageView imageView;

    public CropAreaView(Context context) {
        this(context, null);
    }

    public CropAreaView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.paintClear.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.paintClear.setAntiAlias(true);
        this.paint.setAntiAlias(true);
        float defaultBorderWidth = UnitsUtils.toPixels(this.getContext(), 1, 2.0f);
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.CropAreaView);
        this.backColor = arr.getColor(R.styleable.CropAreaView_gest_backgroundColor, BACK_COLOR);
        this.borderColor = arr.getColor(R.styleable.CropAreaView_gest_borderColor, -1);
        this.borderWidth = arr.getDimension(R.styleable.CropAreaView_gest_borderWidth, defaultBorderWidth);
        this.horizontalRules = arr.getInt(R.styleable.CropAreaView_gest_rulesHorizontal, 0);
        this.verticalRules = arr.getInt(R.styleable.CropAreaView_gest_rulesVertical, 0);
        this.rulesWidth = arr.getDimension(R.styleable.CropAreaView_gest_rulesWidth, 0.0f);
        boolean rounded = arr.getBoolean(R.styleable.CropAreaView_gest_rounded, false);
        this.aspect = arr.getFloat(R.styleable.CropAreaView_gest_aspect, 0.0f);
        arr.recycle();
        this.endRounding = rounded ? 1.0f : 0.0f;
        this.rounding = this.endRounding;
    }

    public void setBackColor(@ColorInt int color) {
        this.backColor = color;
        this.invalidate();
    }

    public void setBorderColor(@ColorInt int color) {
        this.borderColor = color;
        this.invalidate();
    }

    public void setBorderWidth(float width) {
        this.borderWidth = width;
        this.invalidate();
    }

    public void setRulesCount(int horizontalRules, int verticalRules) {
        this.horizontalRules = horizontalRules;
        this.verticalRules = verticalRules;
        this.invalidate();
    }

    public void setRulesWidth(float width) {
        this.rulesWidth = width;
        this.invalidate();
    }

    public void setRounded(boolean rounded) {
        this.startRounding = this.rounding;
        this.endRounding = rounded ? 1.0f : 0.0f;
    }

    public void setAspect(float aspect) {
        this.aspect = aspect;
    }

    public void setImageView(GestureImageView imageView) {
        this.imageView = imageView;
        imageView.getController().getSettings().setFitMethod(Settings.Fit.OUTSIDE).setFillViewport(true).setFlingEnabled(false);
        this.update(false);
    }

    public void update(boolean animate) {
        Settings settings;
        Settings settings2 = settings = this.imageView == null ? null : this.imageView.getController().getSettings();
        if (settings != null && this.getWidth() > 0 && this.getHeight() > 0) {
            if (this.aspect > 0.0f || this.aspect == -1.0f) {
                float realAspect;
                int width = this.getWidth() - this.getPaddingLeft() - this.getPaddingRight();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                float f = realAspect = this.aspect == -1.0f ? (float)settings.getImageW() / (float)settings.getImageH() : this.aspect;
                if (realAspect > (float)width / (float)height) {
                    settings.setMovementArea(width, (int)((float)width / realAspect));
                } else {
                    settings.setMovementArea((int)((float)height * realAspect), height);
                }
                if (animate) {
                    this.imageView.getController().animateKeepInBounds();
                } else {
                    this.imageView.getController().updateState();
                }
            }
            this.startRect.set(this.areaRect);
            GravityUtils.getMovementAreaPosition(settings, tmpRect);
            this.endRect.set(tmpRect);
            this.stateScroller.forceFinished();
            if (animate) {
                this.stateScroller.setDuration(settings.getAnimationsDuration());
                this.stateScroller.startScroll(0.0f, 1.0f);
                this.animationEngine.start();
            } else {
                this.setBounds(this.endRect, this.endRounding);
            }
        }
    }

    private void setBounds(RectF rect, float rounding) {
        this.areaRect.set(rect);
        this.rounding = rounding;
        this.strokeRect.set(rect);
        float halfStroke = 0.5f * this.borderWidth;
        this.strokeRect.inset(-halfStroke, -halfStroke);
        this.invalidate();
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        this.update(false);
        if (this.imageView != null) {
            this.imageView.getController().resetState();
        }
        if (this.isInEditMode()) {
            float sizeY;
            float sizeX;
            float w = width - this.getPaddingLeft() - this.getPaddingRight();
            float h = height - this.getPaddingTop() - this.getPaddingBottom();
            if (this.aspect <= 0.0f) {
                sizeX = width;
                sizeY = height;
            } else if (this.aspect > w / h) {
                sizeX = w;
                sizeY = w / this.aspect;
            } else {
                sizeX = h * this.aspect;
                sizeY = h;
            }
            this.areaRect.set(0.5f * ((float)width - sizeX), 0.5f * ((float)height - sizeY), 0.5f * ((float)width + sizeX), 0.5f * ((float)height + sizeY));
            this.strokeRect.set(this.areaRect);
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.rounding == 0.0f || this.isInEditMode()) {
            this.drawRectHole(canvas);
        } else {
            this.drawRoundedHole(canvas);
        }
        this.drawBorderAndRules(canvas);
    }

    private void drawRectHole(Canvas canvas) {
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.backColor);
        tmpRectF.set(0.0f, 0.0f, (float)canvas.getWidth(), this.areaRect.top);
        canvas.drawRect(tmpRectF, this.paint);
        tmpRectF.set(0.0f, this.areaRect.bottom, (float)canvas.getWidth(), (float)canvas.getHeight());
        canvas.drawRect(tmpRectF, this.paint);
        tmpRectF.set(0.0f, this.areaRect.top, this.areaRect.left, this.areaRect.bottom);
        canvas.drawRect(tmpRectF, this.paint);
        tmpRectF.set(this.areaRect.right, this.areaRect.top, (float)canvas.getWidth(), this.areaRect.bottom);
        canvas.drawRect(tmpRectF, this.paint);
    }

    private void drawRoundedHole(Canvas canvas) {
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.backColor);
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null);
        } else {
            canvas.saveLayer(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight(), null, 0);
        }
        canvas.drawPaint(this.paint);
        float rx = this.rounding * 0.5f * this.areaRect.width();
        float ry = this.rounding * 0.5f * this.areaRect.height();
        canvas.drawRoundRect(this.areaRect, rx, ry, this.paintClear);
        canvas.restore();
    }

    private void drawBorderAndRules(Canvas canvas) {
        int i;
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.borderColor);
        this.paint.setStrokeWidth(this.rulesWidth == 0.0f ? 0.5f * this.borderWidth : this.rulesWidth);
        float rx = this.rounding * 0.5f * this.areaRect.width();
        float ry = this.rounding * 0.5f * this.areaRect.height();
        for (i = 0; i < this.verticalRules; ++i) {
            float px = this.areaRect.left + (float)(i + 1) * (this.areaRect.width() / (float)(this.verticalRules + 1));
            float dy = this.getRulesOffset(px, rx, ry, this.areaRect.left, this.areaRect.right);
            canvas.drawLine(px, this.areaRect.top + dy, px, this.areaRect.bottom - dy, this.paint);
        }
        for (i = 0; i < this.horizontalRules; ++i) {
            float py = this.areaRect.top + (float)(i + 1) * (this.areaRect.height() / (float)(this.horizontalRules + 1));
            float dx = this.getRulesOffset(py, ry, rx, this.areaRect.top, this.areaRect.bottom);
            canvas.drawLine(this.areaRect.left + dx, py, this.areaRect.right - dx, py, this.paint);
        }
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.borderColor);
        this.paint.setStrokeWidth(this.borderWidth);
        canvas.drawRoundRect(this.strokeRect, rx, ry, this.paint);
    }

    private float getRulesOffset(float x, float rx, float ry, float start, float end) {
        float dx = 0.0f;
        if (x - start < rx) {
            dx = start + rx - x;
        } else if (end - x < rx) {
            dx = x - end + rx;
        }
        return rx == 0.0f ? 0.0f : ry * (1.0f - (float)Math.sqrt(1.0f - dx * dx / rx / rx));
    }

    private class LocalAnimationEngine
    extends AnimationEngine {
        LocalAnimationEngine() {
            super(CropAreaView.this);
        }

        @Override
        public boolean onStep() {
            if (!CropAreaView.this.stateScroller.isFinished()) {
                CropAreaView.this.stateScroller.computeScroll();
                float state = CropAreaView.this.stateScroller.getCurr();
                MathUtils.interpolate(CropAreaView.this.areaRect, CropAreaView.this.startRect, CropAreaView.this.endRect, state);
                float rounding = MathUtils.interpolate(CropAreaView.this.startRounding, CropAreaView.this.endRounding, state);
                CropAreaView.this.setBounds(CropAreaView.this.areaRect, rounding);
                return true;
            }
            return false;
        }
    }
}

