/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.animation;

import android.os.Build;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewTreeObserver;
import com.alexvasilkov.gestures.animation.ViewPosition;

class ViewPositionHolder
implements ViewTreeObserver.OnPreDrawListener {
    private final ViewPosition pos = ViewPosition.newInstance();
    private OnViewPositionChangeListener listener;
    private View view;
    private boolean isPaused;

    ViewPositionHolder() {
    }

    public boolean onPreDraw() {
        this.update();
        return true;
    }

    void init(@NonNull View view, @NonNull OnViewPositionChangeListener listener) {
        this.view = view;
        this.listener = listener;
        view.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        if (this.isLaidOut()) {
            this.update();
        }
    }

    void clear() {
        if (this.view != null) {
            this.view.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
        }
        this.pos.view.setEmpty();
        this.pos.viewport.setEmpty();
        this.pos.image.setEmpty();
        this.view = null;
        this.listener = null;
        this.isPaused = false;
    }

    void pause(boolean paused) {
        if (this.isPaused == paused) {
            return;
        }
        this.isPaused = paused;
        this.update();
    }

    private void update() {
        boolean changed;
        if (this.view != null && this.listener != null && !this.isPaused && (changed = ViewPosition.apply(this.pos, this.view))) {
            this.listener.onViewPositionChanged(this.pos);
        }
    }

    private boolean isLaidOut() {
        if (Build.VERSION.SDK_INT >= 19) {
            return this.view.isLaidOut();
        }
        return this.view.getWidth() > 0 && this.view.getHeight() > 0;
    }

    static interface OnViewPositionChangeListener {
        public void onViewPositionChanged(@NonNull ViewPosition var1);
    }
}

