/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.animation;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.RectF;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.util.Log;
import android.view.View;
import com.alexvasilkov.gestures.GestureController;
import com.alexvasilkov.gestures.GestureControllerForPager;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.animation.ViewPosition;
import com.alexvasilkov.gestures.animation.ViewPositionHolder;
import com.alexvasilkov.gestures.internal.AnimationEngine;
import com.alexvasilkov.gestures.internal.GestureDebug;
import com.alexvasilkov.gestures.utils.FloatScroller;
import com.alexvasilkov.gestures.utils.GravityUtils;
import com.alexvasilkov.gestures.utils.MathUtils;
import com.alexvasilkov.gestures.views.interfaces.ClipBounds;
import com.alexvasilkov.gestures.views.interfaces.ClipView;
import com.alexvasilkov.gestures.views.interfaces.GestureView;
import java.util.ArrayList;
import java.util.List;

public class ViewPositionAnimator {
    private static final String TAG = "ViewPositionAnimator";
    private static final Matrix tmpMatrix = new Matrix();
    private static final float[] tmpPointArr = new float[2];
    private static final Point tmpPoint = new Point();
    private final List<PositionUpdateListener> listeners = new ArrayList<PositionUpdateListener>();
    private final List<PositionUpdateListener> listenersToRemove = new ArrayList<PositionUpdateListener>();
    private boolean iteratingListeners;
    private final FloatScroller positionScroller = new FloatScroller();
    private final AnimationEngine animationEngine;
    private final GestureController toController;
    private final ClipView toClipView;
    private final ClipBounds toClipBounds;
    private final State fromState = new State();
    private final State toState = new State();
    private float fromPivotX;
    private float fromPivotY;
    private float toPivotX;
    private float toPivotY;
    private final RectF fromClip = new RectF();
    private final RectF toClip = new RectF();
    private final RectF fromBoundsClip = new RectF();
    private final RectF toBoundsClip = new RectF();
    private final RectF clipRectTmp = new RectF();
    private ViewPosition fromPos;
    private ViewPosition toPos;
    private boolean fromNonePos;
    private View fromView;
    private boolean isActivated = false;
    private float toPosition = 1.0f;
    private float position = 0.0f;
    private boolean isLeaving = true;
    private boolean isAnimating = false;
    private boolean isApplyingPosition;
    private boolean isApplyingPositionScheduled;
    private boolean isFromUpdated;
    private boolean isToUpdated;
    private final ViewPositionHolder fromPosHolder = new ViewPositionHolder();
    private final ViewPositionHolder toPosHolder = new ViewPositionHolder();
    private final ViewPositionHolder.OnViewPositionChangeListener fromPositionListener = new ViewPositionHolder.OnViewPositionChangeListener(){

        @Override
        public void onViewPositionChanged(@NonNull ViewPosition position) {
            if (GestureDebug.isDebugAnimator()) {
                Log.d((String)ViewPositionAnimator.TAG, (String)("'From' view position updated: " + position.pack()));
            }
            ViewPositionAnimator.this.fromPos = position;
            ViewPositionAnimator.this.requestUpdateFromState();
            ViewPositionAnimator.this.applyCurrentPosition();
        }
    };

    public ViewPositionAnimator(@NonNull GestureView to) {
        if (!(to instanceof View)) {
            throw new IllegalArgumentException("Argument 'to' should be an instance of View");
        }
        View toView = (View)to;
        this.toClipView = to instanceof ClipView ? (ClipView)((Object)to) : null;
        this.toClipBounds = to instanceof ClipBounds ? (ClipBounds)((Object)to) : null;
        this.animationEngine = new LocalAnimationEngine(toView);
        this.toController = to.getController();
        this.toController.addOnStateChangeListener(new GestureController.OnStateChangeListener(){

            @Override
            public void onStateChanged(State state) {
                ViewPositionAnimator.this.toController.getStateController().applyZoomPatch(ViewPositionAnimator.this.fromState);
                ViewPositionAnimator.this.toController.getStateController().applyZoomPatch(ViewPositionAnimator.this.toState);
            }

            @Override
            public void onStateReset(State oldState, State newState) {
                if (!ViewPositionAnimator.this.isActivated) {
                    return;
                }
                if (GestureDebug.isDebugAnimator()) {
                    Log.d((String)ViewPositionAnimator.TAG, (String)("State reset in listener: " + newState));
                }
                ViewPositionAnimator.this.setToState(newState, 1.0f);
                ViewPositionAnimator.this.applyCurrentPosition();
            }
        });
        this.toPosHolder.init(toView, new ViewPositionHolder.OnViewPositionChangeListener(){

            @Override
            public void onViewPositionChanged(@NonNull ViewPosition position) {
                if (GestureDebug.isDebugAnimator()) {
                    Log.d((String)ViewPositionAnimator.TAG, (String)("'To' view position updated: " + position.pack()));
                }
                ViewPositionAnimator.this.toPos = position;
                ViewPositionAnimator.this.requestUpdateToState();
                ViewPositionAnimator.this.requestUpdateFromState();
                ViewPositionAnimator.this.applyCurrentPosition();
            }
        });
        this.fromPosHolder.pause(true);
        this.toPosHolder.pause(true);
    }

    public void enter(boolean withAnimation) {
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Entering from none position, with animation = " + withAnimation));
        }
        this.enterInternal(withAnimation);
        this.updateInternal();
    }

    public void enter(@NonNull View from, boolean withAnimation) {
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Entering from view, with animation = " + withAnimation));
        }
        this.enterInternal(withAnimation);
        this.updateInternal(from);
    }

    public void enter(@NonNull ViewPosition fromPos, boolean withAnimation) {
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Entering from view position, with animation = " + withAnimation));
        }
        this.enterInternal(withAnimation);
        this.updateInternal(fromPos);
    }

    public void update(@NonNull View from) {
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)"Updating view");
        }
        this.updateInternal(from);
    }

    public void update(@NonNull ViewPosition from) {
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Updating view position: " + from.pack()));
        }
        this.updateInternal(from);
    }

    public void updateToNone() {
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)"Updating view to no specific position");
        }
        this.updateInternal();
    }

    public void exit(boolean withAnimation) {
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Exiting, with animation = " + withAnimation));
        }
        if (!this.isActivated) {
            throw new IllegalStateException("You should call enter(...) before calling exit(...)");
        }
        if (!(this.isAnimating && this.position <= this.toPosition || !(this.position > 0.0f))) {
            this.setToState(this.toController.getState(), this.position);
        }
        this.setState(withAnimation ? this.position : 0.0f, true, withAnimation);
    }

    private void enterInternal(boolean withAnimation) {
        this.isActivated = true;
        this.toController.updateState();
        this.setToState(this.toController.getState(), 1.0f);
        this.setState(withAnimation ? 0.0f : 1.0f, false, withAnimation);
    }

    private void updateInternal(@NonNull View from) {
        this.cleanBeforeUpdateInternal();
        this.fromView = from;
        this.fromPosHolder.init(from, this.fromPositionListener);
        from.setVisibility(4);
    }

    private void updateInternal(@NonNull ViewPosition from) {
        this.cleanBeforeUpdateInternal();
        this.fromPos = from;
        this.applyCurrentPosition();
    }

    private void updateInternal() {
        this.cleanBeforeUpdateInternal();
        this.fromNonePos = true;
        this.applyCurrentPosition();
    }

    private void cleanBeforeUpdateInternal() {
        if (!this.isActivated) {
            throw new IllegalStateException("You should call enter(...) before calling update(...)");
        }
        this.cleanup();
        this.requestUpdateFromState();
    }

    private void cleanup() {
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)"Cleaning up");
        }
        if (this.fromView != null) {
            this.fromView.setVisibility(0);
        }
        if (this.toClipView != null) {
            this.toClipView.clipView(null, 0.0f);
        }
        this.fromPosHolder.clear();
        this.fromView = null;
        this.fromPos = null;
        this.fromNonePos = false;
        this.isToUpdated = false;
        this.isFromUpdated = false;
    }

    public void addPositionUpdateListener(@NonNull PositionUpdateListener listener) {
        this.listeners.add(listener);
        this.listenersToRemove.remove(listener);
    }

    public void removePositionUpdateListener(@NonNull PositionUpdateListener listener) {
        if (this.iteratingListeners) {
            this.listenersToRemove.add(listener);
        } else {
            this.listeners.remove(listener);
        }
    }

    private void ensurePositionUpdateListenersRemoved() {
        this.listeners.removeAll(this.listenersToRemove);
        this.listenersToRemove.clear();
    }

    @Deprecated
    public long getDuration() {
        return this.toController.getSettings().getAnimationsDuration();
    }

    @Deprecated
    public void setDuration(long duration) {
        this.toController.getSettings().setAnimationsDuration(duration);
    }

    public float getToPosition() {
        return this.toPosition;
    }

    public float getPosition() {
        return this.position;
    }

    @Deprecated
    public float getPositionState() {
        return this.position;
    }

    public boolean isLeaving() {
        return this.isLeaving;
    }

    public void setToState(State state, @FloatRange(from=0.0, to=1.0) float position) {
        if (position <= 0.0f) {
            throw new IllegalArgumentException("'To' position cannot be <= 0");
        }
        if (position > 1.0f) {
            throw new IllegalArgumentException("'To' position cannot be > 1");
        }
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("State reset: " + state + " at " + position));
        }
        this.toPosition = position;
        this.toState.set(state);
        this.requestUpdateToState();
        this.requestUpdateFromState();
    }

    public void setState(@FloatRange(from=0.0, to=1.0) float pos, boolean leaving, boolean animate) {
        if (!this.isActivated) {
            throw new IllegalStateException("You should call enter(...) before calling setState(...)");
        }
        this.stopAnimation();
        this.position = pos < 0.0f ? 0.0f : (pos > 1.0f ? 1.0f : pos);
        this.isLeaving = leaving;
        if (animate) {
            this.startAnimationInternal();
        }
        this.applyCurrentPosition();
    }

    private void applyCurrentPosition() {
        boolean canUpdate;
        if (!this.isActivated) {
            return;
        }
        if (this.isApplyingPosition) {
            this.isApplyingPositionScheduled = true;
            return;
        }
        this.isApplyingPosition = true;
        boolean paused = this.isLeaving ? this.position == 0.0f : this.position == 1.0f;
        this.fromPosHolder.pause(paused);
        this.toPosHolder.pause(paused);
        if (!this.isToUpdated) {
            this.updateToState();
        }
        if (!this.isFromUpdated) {
            this.updateFromState();
        }
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)("Applying state: " + this.position + " / " + this.isLeaving + ", 'to' ready = " + this.isToUpdated + ", 'from' ready = " + this.isFromUpdated));
        }
        boolean bl = canUpdate = this.position < this.toPosition || this.isAnimating && this.position == this.toPosition;
        if (this.isToUpdated && this.isFromUpdated && canUpdate) {
            State state = this.toController.getState();
            MathUtils.interpolate(state, this.fromState, this.fromPivotX, this.fromPivotY, this.toState, this.toPivotX, this.toPivotY, this.position / this.toPosition);
            this.toController.updateState();
            boolean skipClip = this.position >= this.toPosition || this.position == 0.0f && this.isLeaving;
            float clipPosition = this.position / this.toPosition;
            if (this.toClipView != null) {
                MathUtils.interpolate(this.clipRectTmp, this.fromClip, this.toClip, clipPosition);
                this.toClipView.clipView(skipClip ? null : this.clipRectTmp, state.getRotation());
            }
            if (this.toClipBounds != null) {
                float boundsClipPos = clipPosition * clipPosition;
                MathUtils.interpolate(this.clipRectTmp, this.fromBoundsClip, this.toBoundsClip, boundsClipPos);
                this.toClipBounds.clipBounds(skipClip ? null : this.clipRectTmp);
            }
        }
        this.iteratingListeners = true;
        int size = this.listeners.size();
        for (int i = 0; i < size && !this.isApplyingPositionScheduled; ++i) {
            this.listeners.get(i).onPositionUpdate(this.position, this.isLeaving);
        }
        this.iteratingListeners = false;
        this.ensurePositionUpdateListenersRemoved();
        if (this.position == 0.0f && this.isLeaving) {
            this.cleanup();
            this.isActivated = false;
            this.toController.resetState();
        }
        this.isApplyingPosition = false;
        if (this.isApplyingPositionScheduled) {
            this.isApplyingPositionScheduled = false;
            this.applyCurrentPosition();
        }
    }

    public boolean isAnimating() {
        return this.isAnimating;
    }

    private void startAnimationInternal() {
        long duration = this.toController.getSettings().getAnimationsDuration();
        float durationFraction = this.toPosition == 1.0f ? (this.isLeaving ? this.position : 1.0f - this.position) : (this.isLeaving ? this.position / this.toPosition : (1.0f - this.position) / (1.0f - this.toPosition));
        this.positionScroller.setDuration((long)((float)duration * durationFraction));
        this.positionScroller.startScroll(this.position, this.isLeaving ? 0.0f : 1.0f);
        this.animationEngine.start();
        this.onAnimationStarted();
    }

    public void stopAnimation() {
        this.positionScroller.forceFinished();
        this.onAnimationStopped();
    }

    private void onAnimationStarted() {
        if (this.isAnimating) {
            return;
        }
        this.isAnimating = true;
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)"Animation started");
        }
        this.toController.getSettings().disableBounds().disableGestures();
        this.toController.stopAllAnimations();
        if (this.toController instanceof GestureControllerForPager) {
            ((GestureControllerForPager)this.toController).disableViewPager(true);
        }
    }

    private void onAnimationStopped() {
        if (!this.isAnimating) {
            return;
        }
        this.isAnimating = false;
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)"Animation stopped");
        }
        this.toController.getSettings().enableBounds().enableGestures();
        if (this.toController instanceof GestureControllerForPager) {
            ((GestureControllerForPager)this.toController).disableViewPager(false);
        }
        this.toController.animateKeepInBounds();
    }

    private void requestUpdateToState() {
        this.isToUpdated = false;
    }

    private void requestUpdateFromState() {
        this.isFromUpdated = false;
    }

    private void updateToState() {
        Settings settings;
        if (this.isToUpdated) {
            return;
        }
        Settings settings2 = settings = this.toController == null ? null : this.toController.getSettings();
        if (this.toPos == null || settings == null || !settings.hasImageSize()) {
            return;
        }
        this.toState.get(tmpMatrix);
        this.toClip.set(0.0f, 0.0f, (float)settings.getImageW(), (float)settings.getImageH());
        ViewPositionAnimator.tmpPointArr[0] = this.toClip.centerX();
        ViewPositionAnimator.tmpPointArr[1] = this.toClip.centerY();
        tmpMatrix.mapPoints(tmpPointArr);
        this.toPivotX = tmpPointArr[0];
        this.toPivotY = tmpPointArr[1];
        tmpMatrix.postRotate(-this.toState.getRotation(), this.toPivotX, this.toPivotY);
        tmpMatrix.mapRect(this.toClip);
        this.toClip.offset((float)(this.toPos.viewport.left - this.toPos.view.left), (float)(this.toPos.viewport.top - this.toPos.view.top));
        this.toBoundsClip.set(0.0f, 0.0f, (float)this.toPos.view.width(), (float)this.toPos.view.height());
        this.isToUpdated = true;
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)"'To' state updated");
        }
    }

    private void updateFromState() {
        Settings settings;
        if (this.isFromUpdated) {
            return;
        }
        Settings settings2 = settings = this.toController == null ? null : this.toController.getSettings();
        if (this.fromNonePos && settings != null && this.toPos != null) {
            this.fromPos = this.fromPos == null ? ViewPosition.newInstance() : this.fromPos;
            GravityUtils.getDefaultPivot(settings, tmpPoint);
            tmpPoint.offset(this.toPos.view.left, this.toPos.view.top);
            ViewPosition.apply(this.fromPos, tmpPoint);
        }
        if (this.toPos == null || this.fromPos == null || settings == null || !settings.hasImageSize()) {
            return;
        }
        this.fromPivotX = this.fromPos.image.centerX() - this.toPos.viewport.left;
        this.fromPivotY = this.fromPos.image.centerY() - this.toPos.viewport.top;
        float imageWidth = settings.getImageW();
        float imageHeight = settings.getImageH();
        float zoomW = imageWidth == 0.0f ? 1.0f : (float)this.fromPos.image.width() / imageWidth;
        float zoomH = imageHeight == 0.0f ? 1.0f : (float)this.fromPos.image.height() / imageHeight;
        float zoom = Math.max(zoomW, zoomH);
        float fromX = (float)this.fromPos.image.centerX() - 0.5f * imageWidth * zoom - (float)this.toPos.viewport.left;
        float fromY = (float)this.fromPos.image.centerY() - 0.5f * imageHeight * zoom - (float)this.toPos.viewport.top;
        this.fromState.set(fromX, fromY, zoom, 0.0f);
        this.fromClip.set(this.fromPos.viewport);
        this.fromClip.offset((float)(-this.toPos.view.left), (float)(-this.toPos.view.top));
        this.fromBoundsClip.set(0.0f, 0.0f, (float)this.toPos.view.width(), (float)this.toPos.view.height());
        this.fromBoundsClip.left = this.compareAndSetClipBound(this.fromBoundsClip.left, this.fromPos.view.left, this.fromPos.visible.left, this.toPos.view.left);
        this.fromBoundsClip.top = this.compareAndSetClipBound(this.fromBoundsClip.top, this.fromPos.view.top, this.fromPos.visible.top, this.toPos.view.top);
        this.fromBoundsClip.right = this.compareAndSetClipBound(this.fromBoundsClip.right, this.fromPos.view.right, this.fromPos.visible.right, this.toPos.view.left);
        this.fromBoundsClip.bottom = this.compareAndSetClipBound(this.fromBoundsClip.bottom, this.fromPos.view.bottom, this.fromPos.visible.bottom, this.toPos.view.top);
        this.isFromUpdated = true;
        if (GestureDebug.isDebugAnimator()) {
            Log.d((String)TAG, (String)"'From' state updated");
        }
    }

    private float compareAndSetClipBound(float origBound, int viewPos, int visiblePos, int offset) {
        if (-1 <= viewPos - visiblePos && viewPos - visiblePos <= 1) {
            return origBound;
        }
        return visiblePos - offset;
    }

    public static interface PositionUpdateListener {
        public void onPositionUpdate(float var1, boolean var2);
    }

    private class LocalAnimationEngine
    extends AnimationEngine {
        LocalAnimationEngine(View view) {
            super(view);
        }

        @Override
        public boolean onStep() {
            if (!ViewPositionAnimator.this.positionScroller.isFinished()) {
                ViewPositionAnimator.this.positionScroller.computeScroll();
                ViewPositionAnimator.this.position = ViewPositionAnimator.this.positionScroller.getCurr();
                ViewPositionAnimator.this.applyCurrentPosition();
                if (ViewPositionAnimator.this.positionScroller.isFinished()) {
                    ViewPositionAnimator.this.onAnimationStopped();
                }
                return true;
            }
            return false;
        }
    }
}

