/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.animation;

import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import com.alexvasilkov.gestures.animation.ImageViewHelper;
import java.util.regex.Pattern;

public class ViewPosition {
    private static final String DELIMITER = "#";
    private static final Pattern SPLIT_PATTERN = Pattern.compile("#");
    private static final int[] tmpLocation = new int[2];
    private static final Matrix tmpMatrix = new Matrix();
    private static final RectF tmpSrc = new RectF();
    private static final RectF tmpDst = new RectF();
    private static final Rect tmpViewRect = new Rect();
    public final Rect view;
    public final Rect viewport;
    public final Rect visible;
    public final Rect image;

    private ViewPosition() {
        this.view = new Rect();
        this.viewport = new Rect();
        this.visible = new Rect();
        this.image = new Rect();
    }

    private ViewPosition(@NonNull Rect view, @NonNull Rect viewport, @NonNull Rect visible, @NonNull Rect image) {
        this.view = view;
        this.viewport = viewport;
        this.visible = visible;
        this.image = image;
    }

    public void set(@NonNull ViewPosition pos) {
        this.view.set(pos.view);
        this.viewport.set(pos.viewport);
        this.visible.set(pos.visible);
        this.image.set(pos.image);
    }

    private boolean init(@NonNull View targetView) {
        if (targetView.getWindowToken() == null) {
            return false;
        }
        tmpViewRect.set(this.view);
        targetView.getLocationOnScreen(tmpLocation);
        this.view.set(0, 0, targetView.getWidth(), targetView.getHeight());
        this.view.offset(tmpLocation[0], tmpLocation[1]);
        this.viewport.set(targetView.getPaddingLeft(), targetView.getPaddingTop(), targetView.getWidth() - targetView.getPaddingRight(), targetView.getHeight() - targetView.getPaddingBottom());
        this.viewport.offset(tmpLocation[0], tmpLocation[1]);
        boolean isVisible = targetView.getGlobalVisibleRect(this.visible);
        if (!isVisible) {
            this.visible.set(this.view.centerX(), this.view.centerY(), this.view.centerX() + 1, this.view.centerY() + 1);
        }
        if (targetView instanceof ImageView) {
            ImageView imageView = (ImageView)targetView;
            Drawable drawable = imageView.getDrawable();
            if (drawable == null) {
                this.image.set(this.viewport);
            } else {
                int drawableWidth = drawable.getIntrinsicWidth();
                int drawableHeight = drawable.getIntrinsicHeight();
                ImageViewHelper.applyScaleType(imageView.getScaleType(), drawableWidth, drawableHeight, this.viewport.width(), this.viewport.height(), imageView.getImageMatrix(), tmpMatrix);
                tmpSrc.set(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
                tmpMatrix.mapRect(tmpDst, tmpSrc);
                this.image.left = this.viewport.left + (int)ViewPosition.tmpDst.left;
                this.image.top = this.viewport.top + (int)ViewPosition.tmpDst.top;
                this.image.right = this.viewport.left + (int)ViewPosition.tmpDst.right;
                this.image.bottom = this.viewport.top + (int)ViewPosition.tmpDst.bottom;
            }
        } else {
            this.image.set(this.viewport);
        }
        return !tmpViewRect.equals((Object)this.view);
    }

    public static ViewPosition newInstance() {
        return new ViewPosition();
    }

    public static ViewPosition from(@NonNull View view) {
        ViewPosition pos = new ViewPosition();
        pos.init(view);
        return pos;
    }

    public static boolean apply(@NonNull ViewPosition pos, @NonNull View view) {
        return pos.init(view);
    }

    public static void apply(@NonNull ViewPosition pos, @NonNull Point point) {
        pos.view.set(point.x, point.y, point.x + 1, point.y + 1);
        pos.viewport.set(pos.view);
        pos.visible.set(pos.view);
        pos.image.set(pos.view);
    }

    public String pack() {
        String viewStr = this.view.flattenToString();
        String viewportStr = this.viewport.flattenToString();
        String visibleStr = this.visible.flattenToString();
        String imageStr = this.image.flattenToString();
        return TextUtils.join((CharSequence)DELIMITER, (Object[])new String[]{viewStr, viewportStr, visibleStr, imageStr});
    }

    public static ViewPosition unpack(String str) {
        String[] parts = TextUtils.split((String)str, (Pattern)SPLIT_PATTERN);
        if (parts.length != 4) {
            throw new IllegalArgumentException("Wrong ViewPosition string: " + str);
        }
        Rect view = Rect.unflattenFromString((String)parts[0]);
        Rect viewport = Rect.unflattenFromString((String)parts[1]);
        Rect visible = Rect.unflattenFromString((String)parts[2]);
        Rect image = Rect.unflattenFromString((String)parts[3]);
        if (view == null || viewport == null || image == null) {
            throw new IllegalArgumentException("Wrong ViewPosition string: " + str);
        }
        return new ViewPosition(view, viewport, visible, image);
    }
}

