/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures.animation;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.widget.ImageView;

class ImageViewHelper {
    private static final RectF tmpSrc = new RectF();
    private static final RectF tmpDst = new RectF();

    private ImageViewHelper() {
    }

    static void applyScaleType(ImageView.ScaleType type, int dwidth, int dheight, int vwidth, int vheight, Matrix imageMatrix, Matrix outMatrix) {
        if (ImageView.ScaleType.CENTER == type) {
            outMatrix.setTranslate((float)(vwidth - dwidth) * 0.5f, (float)(vheight - dheight) * 0.5f);
        } else if (ImageView.ScaleType.CENTER_CROP == type) {
            float scale;
            float dx = 0.0f;
            float dy = 0.0f;
            if (dwidth * vheight > vwidth * dheight) {
                scale = (float)vheight / (float)dheight;
                dx = ((float)vwidth - (float)dwidth * scale) * 0.5f;
            } else {
                scale = (float)vwidth / (float)dwidth;
                dy = ((float)vheight - (float)dheight * scale) * 0.5f;
            }
            outMatrix.setScale(scale, scale);
            outMatrix.postTranslate(dx, dy);
        } else if (ImageView.ScaleType.CENTER_INSIDE == type) {
            float scale = dwidth <= vwidth && dheight <= vheight ? 1.0f : Math.min((float)vwidth / (float)dwidth, (float)vheight / (float)dheight);
            float dx = ((float)vwidth - (float)dwidth * scale) * 0.5f;
            float dy = ((float)vheight - (float)dheight * scale) * 0.5f;
            outMatrix.setScale(scale, scale);
            outMatrix.postTranslate(dx, dy);
        } else {
            Matrix.ScaleToFit scaleToFit = ImageViewHelper.scaleTypeToScaleToFit(type);
            if (scaleToFit == null) {
                outMatrix.set(imageMatrix);
            } else {
                tmpSrc.set(0.0f, 0.0f, (float)dwidth, (float)dheight);
                tmpDst.set(0.0f, 0.0f, (float)vwidth, (float)vheight);
                outMatrix.setRectToRect(tmpSrc, tmpDst, scaleToFit);
            }
        }
    }

    private static Matrix.ScaleToFit scaleTypeToScaleToFit(ImageView.ScaleType type) {
        switch (type) {
            case FIT_XY: {
                return Matrix.ScaleToFit.FILL;
            }
            case FIT_START: {
                return Matrix.ScaleToFit.START;
            }
            case FIT_CENTER: {
                return Matrix.ScaleToFit.CENTER;
            }
            case FIT_END: {
                return Matrix.ScaleToFit.END;
            }
        }
        return null;
    }
}

