/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.internal.MovementBounds;
import com.alexvasilkov.gestures.internal.ZoomBounds;
import com.alexvasilkov.gestures.utils.GravityUtils;
import com.alexvasilkov.gestures.utils.MathUtils;

public class StateController {
    private static final State tmpState = new State();
    private static final Rect tmpRect = new Rect();
    private static final RectF tmpRectF = new RectF();
    private static final Point tmpPoint = new Point();
    private static final PointF tmpPointF = new PointF();
    private final Settings settings;
    private final ZoomBounds zoomBounds;
    private final MovementBounds movBounds;
    private boolean isResetRequired = true;
    private float zoomPatch;

    StateController(Settings settings) {
        this.settings = settings;
        this.zoomBounds = new ZoomBounds(settings);
        this.movBounds = new MovementBounds(settings);
    }

    boolean resetState(State state) {
        this.isResetRequired = true;
        return this.updateState(state);
    }

    boolean updateState(State state) {
        if (this.isResetRequired) {
            state.set(0.0f, 0.0f, this.zoomBounds.set(state).getFitZoom(), 0.0f);
            GravityUtils.getImagePosition(state, this.settings, tmpRect);
            state.translateTo(StateController.tmpRect.left, StateController.tmpRect.top);
            this.isResetRequired = !this.settings.hasImageSize() || !this.settings.hasViewportSize();
            return !this.isResetRequired;
        }
        this.restrictStateBounds(state, state, Float.NaN, Float.NaN, false, false, true);
        return false;
    }

    public void setTempZoomPatch(float factor) {
        this.zoomPatch = factor;
    }

    public void applyZoomPatch(State state) {
        if (this.zoomPatch > 0.0f) {
            state.set(state.getX(), state.getY(), state.getZoom() * this.zoomPatch, state.getRotation());
        }
    }

    public float applyZoomPatch(float zoom) {
        return this.zoomPatch > 0.0f ? this.zoomPatch * zoom : zoom;
    }

    State toggleMinMaxZoom(State state, float pivotX, float pivotY) {
        this.zoomBounds.set(state);
        float minZoom = this.zoomBounds.getFitZoom();
        float maxZoom = this.settings.getDoubleTapZoom() > 0.0f ? this.settings.getDoubleTapZoom() : this.zoomBounds.getMaxZoom();
        float middleZoom = 0.5f * (minZoom + maxZoom);
        float targetZoom = state.getZoom() < middleZoom ? maxZoom : minZoom;
        State end = state.copy();
        end.zoomTo(targetZoom, pivotX, pivotY);
        return end;
    }

    @Nullable
    State restrictStateBoundsCopy(State state, State prevState, float pivotX, float pivotY, boolean allowOverscroll, boolean allowOverzoom, boolean restrictRotation) {
        tmpState.set(state);
        boolean changed = this.restrictStateBounds(tmpState, prevState, pivotX, pivotY, allowOverscroll, allowOverzoom, restrictRotation);
        return changed ? tmpState.copy() : null;
    }

    boolean restrictStateBounds(State state, State prevState, float pivotX, float pivotY, boolean allowOverscroll, boolean allowOverzoom, boolean restrictRotation) {
        float rotation;
        if (!this.settings.isRestrictBounds()) {
            return false;
        }
        if (Float.isNaN(pivotX) || Float.isNaN(pivotY)) {
            GravityUtils.getDefaultPivot(this.settings, tmpPoint);
            pivotX = StateController.tmpPoint.x;
            pivotY = StateController.tmpPoint.y;
        }
        boolean isStateChanged = false;
        if (restrictRotation && this.settings.isRestrictRotation() && !State.equals(rotation = (float)Math.round(state.getRotation() / 90.0f) * 90.0f, state.getRotation())) {
            state.rotateTo(rotation, pivotX, pivotY);
            isStateChanged = true;
        }
        this.zoomBounds.set(state);
        float minZoom = this.zoomBounds.getMinZoom();
        float maxZoom = this.zoomBounds.getMaxZoom();
        float extraZoom = allowOverzoom ? this.settings.getOverzoomFactor() : 1.0f;
        float zoom = this.zoomBounds.restrict(state.getZoom(), extraZoom);
        if (prevState != null) {
            zoom = this.applyZoomResilience(zoom, prevState.getZoom(), minZoom, maxZoom, extraZoom);
        }
        if (!State.equals(zoom, state.getZoom())) {
            state.zoomTo(zoom, pivotX, pivotY);
            isStateChanged = true;
        }
        float extraX = allowOverscroll ? this.settings.getOverscrollDistanceX() : 0.0f;
        float extraY = allowOverscroll ? this.settings.getOverscrollDistanceY() : 0.0f;
        this.movBounds.set(state);
        this.movBounds.restrict(state.getX(), state.getY(), extraX, extraY, tmpPointF);
        float newX = StateController.tmpPointF.x;
        float newY = StateController.tmpPointF.y;
        if (zoom < minZoom) {
            float factor = (extraZoom * zoom / minZoom - 1.0f) / (extraZoom - 1.0f);
            factor = (float)Math.sqrt(factor);
            this.movBounds.restrict(newX, newY, tmpPointF);
            float strictX = StateController.tmpPointF.x;
            float strictY = StateController.tmpPointF.y;
            newX = strictX + factor * (newX - strictX);
            newY = strictY + factor * (newY - strictY);
        }
        if (prevState != null) {
            this.movBounds.getExternalBounds(tmpRectF);
            newX = this.applyTranslationResilience(newX, prevState.getX(), StateController.tmpRectF.left, StateController.tmpRectF.right, extraX);
            newY = this.applyTranslationResilience(newY, prevState.getY(), StateController.tmpRectF.top, StateController.tmpRectF.bottom, extraY);
        }
        if (!State.equals(newX, state.getX()) || !State.equals(newY, state.getY())) {
            state.translateTo(newX, newY);
            isStateChanged = true;
        }
        return isStateChanged;
    }

    private float applyZoomResilience(float zoom, float prevZoom, float minZoom, float maxZoom, float overzoom) {
        if (overzoom == 1.0f) {
            return zoom;
        }
        float minZoomOver = minZoom / overzoom;
        float maxZoomOver = maxZoom * overzoom;
        float resilience = 0.0f;
        if (zoom < minZoom && zoom < prevZoom) {
            resilience = (minZoom - zoom) / (minZoom - minZoomOver);
        } else if (zoom > maxZoom && zoom > prevZoom) {
            resilience = (zoom - maxZoom) / (maxZoomOver - maxZoom);
        }
        if (resilience == 0.0f) {
            return zoom;
        }
        resilience = (float)Math.sqrt(resilience);
        return zoom + resilience * (prevZoom - zoom);
    }

    private float applyTranslationResilience(float value, float prevValue, float boundsMin, float boundsMax, float overscroll) {
        if (overscroll == 0.0f) {
            return value;
        }
        float resilience = 0.0f;
        float avg = (value + prevValue) * 0.5f;
        if (avg < boundsMin && value < prevValue) {
            resilience = (boundsMin - avg) / overscroll;
        } else if (avg > boundsMax && value > prevValue) {
            resilience = (avg - boundsMax) / overscroll;
        }
        if (resilience == 0.0f) {
            return value;
        }
        if (resilience > 1.0f) {
            resilience = 1.0f;
        }
        resilience = (float)Math.sqrt(resilience);
        return value - resilience * (value - prevValue);
    }

    public float getMinZoom(State state) {
        return this.zoomBounds.set(state).getMinZoom();
    }

    public float getMaxZoom(State state) {
        return this.zoomBounds.set(state).getMaxZoom();
    }

    public float getFitZoom(State state) {
        return this.zoomBounds.set(state).getFitZoom();
    }

    public void getMovementArea(State state, RectF out) {
        this.movBounds.set(state).getExternalBounds(out);
    }

    @Deprecated
    public float getEffectiveMinZoom() {
        return this.zoomBounds.getMinZoom();
    }

    @Deprecated
    public float getEffectiveMaxZoom() {
        return this.zoomBounds.getMaxZoom();
    }

    @Deprecated
    public void getEffectiveMovementArea(RectF out, State state) {
        this.getMovementArea(state, out);
    }

    @Deprecated
    public static float restrict(float value, float minValue, float maxValue) {
        return Math.max(minValue, Math.min(value, maxValue));
    }

    @Deprecated
    public static void interpolate(State out, State start, State end, float factor) {
        MathUtils.interpolate(out, start, end, factor);
    }

    @Deprecated
    public static void interpolate(State out, State start, float startPivotX, float startPivotY, State end, float endPivotX, float endPivotY, float factor) {
        MathUtils.interpolate(out, start, startPivotX, startPivotY, end, endPivotX, endPivotY, factor);
    }

    @Deprecated
    public static float interpolate(float start, float end, float factor) {
        return MathUtils.interpolate(start, end, factor);
    }

    @Deprecated
    public static void interpolate(RectF out, RectF start, RectF end, float factor) {
        MathUtils.interpolate(out, start, end, factor);
    }
}

