/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures;

import android.graphics.Matrix;

public class State {
    public static final float EPSILON = 0.001f;
    private final Matrix matrix = new Matrix();
    private final float[] matrixValues = new float[9];
    private float x;
    private float y;
    private float zoom = 1.0f;
    private float rotation;

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZoom() {
        return this.zoom;
    }

    public float getRotation() {
        return this.rotation;
    }

    public boolean isEmpty() {
        return this.x == 0.0f && this.y == 0.0f && this.zoom == 1.0f && this.rotation == 0.0f;
    }

    public void get(Matrix matrix) {
        matrix.set(this.matrix);
    }

    public void translateBy(float dx, float dy) {
        this.matrix.postTranslate(dx, dy);
        this.updateFromMatrix(false, false);
    }

    public void translateTo(float x, float y) {
        this.matrix.postTranslate(-this.x + x, -this.y + y);
        this.updateFromMatrix(false, false);
    }

    public void zoomBy(float factor, float pivotX, float pivotY) {
        this.matrix.postScale(factor, factor, pivotX, pivotY);
        this.updateFromMatrix(true, false);
    }

    public void zoomTo(float zoom, float pivotX, float pivotY) {
        this.matrix.postScale(zoom / this.zoom, zoom / this.zoom, pivotX, pivotY);
        this.updateFromMatrix(true, false);
    }

    public void rotateBy(float angle, float pivotX, float pivotY) {
        this.matrix.postRotate(angle, pivotX, pivotY);
        this.updateFromMatrix(false, true);
    }

    public void rotateTo(float angle, float pivotX, float pivotY) {
        this.matrix.postRotate(-this.rotation + angle, pivotX, pivotY);
        this.updateFromMatrix(false, true);
    }

    public void set(float x, float y, float zoom, float rotation) {
        while (rotation < -180.0f) {
            rotation += 360.0f;
        }
        while (rotation > 180.0f) {
            rotation -= 360.0f;
        }
        this.x = x;
        this.y = y;
        this.zoom = zoom;
        this.rotation = rotation;
        this.matrix.reset();
        if (zoom != 1.0f) {
            this.matrix.postScale(zoom, zoom);
        }
        if (rotation != 0.0f) {
            this.matrix.postRotate(rotation);
        }
        this.matrix.postTranslate(x, y);
    }

    public void set(Matrix matrix) {
        this.matrix.set(matrix);
        this.updateFromMatrix(true, true);
    }

    public void set(State other) {
        this.x = other.x;
        this.y = other.y;
        this.zoom = other.zoom;
        this.rotation = other.rotation;
        this.matrix.set(other.matrix);
    }

    public State copy() {
        State copy = new State();
        copy.set(this);
        return copy;
    }

    private void updateFromMatrix(boolean updateZoom, boolean updateRotation) {
        this.matrix.getValues(this.matrixValues);
        this.x = this.matrixValues[2];
        this.y = this.matrixValues[5];
        if (updateZoom) {
            this.zoom = (float)Math.hypot(this.matrixValues[1], this.matrixValues[4]);
        }
        if (updateRotation) {
            this.rotation = (float)Math.toDegrees(Math.atan2(this.matrixValues[3], this.matrixValues[4]));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        State state = (State)obj;
        return State.equals(state.x, this.x) && State.equals(state.y, this.y) && State.equals(state.zoom, this.zoom) && State.equals(state.rotation, this.rotation);
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        result = 31 * result + (this.zoom != 0.0f ? Float.floatToIntBits(this.zoom) : 0);
        result = 31 * result + (this.rotation != 0.0f ? Float.floatToIntBits(this.rotation) : 0);
        return result;
    }

    public String toString() {
        return "{x=" + this.x + ",y=" + this.y + ",zoom=" + this.zoom + ",rotation=" + this.rotation + "}";
    }

    public static boolean equals(float v1, float v2) {
        return v1 >= v2 - 0.001f && v1 <= v2 + 0.001f;
    }

    public static int compare(float v1, float v2) {
        return v1 > v2 + 0.001f ? 1 : (v1 < v2 - 0.001f ? -1 : 0);
    }
}

