/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.alexvasilkov.gestures.R;
import com.alexvasilkov.gestures.internal.UnitsUtils;

public class Settings {
    public static final float MAX_ZOOM = 2.0f;
    public static final float OVERZOOM_FACTOR = 2.0f;
    public static final long ANIMATIONS_DURATION = 300L;
    private int viewportW;
    private int viewportH;
    private int movementAreaW;
    private int movementAreaH;
    private boolean isMovementAreaSpecified;
    private int imageW;
    private int imageH;
    private float minZoom = 0.0f;
    private float maxZoom = 2.0f;
    private float doubleTapZoom = -1.0f;
    private float overzoomFactor = 2.0f;
    private float overscrollDistanceX;
    private float overscrollDistanceY;
    private boolean isFillViewport = false;
    private int gravity = 17;
    private Fit fitMethod = Fit.INSIDE;
    private Bounds boundsType = Bounds.NORMAL;
    private boolean isPanEnabled = true;
    private boolean isFlingEnabled = true;
    private boolean isZoomEnabled = true;
    private boolean isRotationEnabled = false;
    private boolean isRestrictRotation = false;
    private boolean isDoubleTapEnabled = true;
    private ExitType exitType = ExitType.ALL;
    private int gesturesDisableCount;
    private int boundsDisableCount;
    private long animationsDuration = 300L;

    Settings() {
    }

    public void initFromAttributes(@NonNull Context context, @Nullable AttributeSet attrs) {
        boolean disableBounds;
        if (attrs == null) {
            return;
        }
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.GestureView);
        this.movementAreaW = arr.getDimensionPixelSize(R.styleable.GestureView_gest_movementAreaWidth, this.movementAreaW);
        this.movementAreaH = arr.getDimensionPixelSize(R.styleable.GestureView_gest_movementAreaHeight, this.movementAreaH);
        this.isMovementAreaSpecified = this.movementAreaW > 0 && this.movementAreaH > 0;
        this.minZoom = arr.getFloat(R.styleable.GestureView_gest_minZoom, this.minZoom);
        this.maxZoom = arr.getFloat(R.styleable.GestureView_gest_maxZoom, this.maxZoom);
        this.doubleTapZoom = arr.getFloat(R.styleable.GestureView_gest_doubleTapZoom, this.doubleTapZoom);
        this.overzoomFactor = arr.getFloat(R.styleable.GestureView_gest_overzoomFactor, this.overzoomFactor);
        this.overscrollDistanceX = arr.getDimension(R.styleable.GestureView_gest_overscrollX, this.overscrollDistanceX);
        this.overscrollDistanceY = arr.getDimension(R.styleable.GestureView_gest_overscrollY, this.overscrollDistanceY);
        this.isFillViewport = arr.getBoolean(R.styleable.GestureView_gest_fillViewport, this.isFillViewport);
        this.gravity = arr.getInt(R.styleable.GestureView_gest_gravity, this.gravity);
        int fitMethodPos = arr.getInteger(R.styleable.GestureView_gest_fitMethod, this.fitMethod.ordinal());
        this.fitMethod = Fit.values()[fitMethodPos];
        int boundsTypePos = arr.getInteger(R.styleable.GestureView_gest_boundsType, this.boundsType.ordinal());
        this.boundsType = Bounds.values()[boundsTypePos];
        this.isPanEnabled = arr.getBoolean(R.styleable.GestureView_gest_panEnabled, this.isPanEnabled);
        this.isFlingEnabled = arr.getBoolean(R.styleable.GestureView_gest_flingEnabled, this.isFlingEnabled);
        this.isZoomEnabled = arr.getBoolean(R.styleable.GestureView_gest_zoomEnabled, this.isZoomEnabled);
        this.isRotationEnabled = arr.getBoolean(R.styleable.GestureView_gest_rotationEnabled, this.isRotationEnabled);
        this.isRestrictRotation = arr.getBoolean(R.styleable.GestureView_gest_restrictRotation, this.isRestrictRotation);
        this.isDoubleTapEnabled = arr.getBoolean(R.styleable.GestureView_gest_doubleTapEnabled, this.isDoubleTapEnabled);
        this.exitType = arr.getBoolean(R.styleable.GestureView_gest_exitEnabled, true) ? this.exitType : ExitType.NONE;
        this.animationsDuration = arr.getInt(R.styleable.GestureView_gest_animationDuration, (int)this.animationsDuration);
        boolean disableGestures = arr.getBoolean(R.styleable.GestureView_gest_disableGestures, false);
        if (disableGestures) {
            this.disableGestures();
        }
        if (disableBounds = arr.getBoolean(R.styleable.GestureView_gest_disableBounds, false)) {
            this.disableBounds();
        }
        arr.recycle();
    }

    public Settings setViewport(int width, int height) {
        this.viewportW = width;
        this.viewportH = height;
        return this;
    }

    public Settings setMovementArea(int width, int height) {
        this.isMovementAreaSpecified = true;
        this.movementAreaW = width;
        this.movementAreaH = height;
        return this;
    }

    public Settings setImage(int width, int height) {
        this.imageW = width;
        this.imageH = height;
        return this;
    }

    public Settings setMinZoom(float minZoom) {
        this.minZoom = minZoom;
        return this;
    }

    public Settings setMaxZoom(float maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    public Settings setDoubleTapZoom(float doubleTapZoom) {
        this.doubleTapZoom = doubleTapZoom;
        return this;
    }

    public Settings setOverzoomFactor(float factor) {
        if (factor < 1.0f) {
            throw new IllegalArgumentException("Overzoom factor cannot be < 1");
        }
        this.overzoomFactor = factor;
        return this;
    }

    public Settings setOverscrollDistance(float distanceX, float distanceY) {
        if (distanceX < 0.0f || distanceY < 0.0f) {
            throw new IllegalArgumentException("Overscroll distance cannot be < 0");
        }
        this.overscrollDistanceX = distanceX;
        this.overscrollDistanceY = distanceY;
        return this;
    }

    public Settings setOverscrollDistance(Context context, float distanceXDp, float distanceYDp) {
        return this.setOverscrollDistance(UnitsUtils.toPixels(context, distanceXDp), UnitsUtils.toPixels(context, distanceYDp));
    }

    public Settings setFillViewport(boolean isFitViewport) {
        this.isFillViewport = isFitViewport;
        return this;
    }

    public Settings setGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public Settings setFitMethod(@NonNull Fit fitMethod) {
        this.fitMethod = fitMethod;
        return this;
    }

    public Settings setBoundsType(@NonNull Bounds boundsType) {
        this.boundsType = boundsType;
        return this;
    }

    public Settings setPanEnabled(boolean enabled) {
        this.isPanEnabled = enabled;
        return this;
    }

    public Settings setFlingEnabled(boolean enabled) {
        this.isFlingEnabled = enabled;
        return this;
    }

    public Settings setZoomEnabled(boolean enabled) {
        this.isZoomEnabled = enabled;
        return this;
    }

    public Settings setRotationEnabled(boolean enabled) {
        this.isRotationEnabled = enabled;
        return this;
    }

    public Settings setRestrictRotation(boolean restrict) {
        this.isRestrictRotation = restrict;
        return this;
    }

    public Settings setDoubleTapEnabled(boolean enabled) {
        this.isDoubleTapEnabled = enabled;
        return this;
    }

    public Settings setExitEnabled(boolean enabled) {
        this.exitType = enabled ? ExitType.ALL : ExitType.NONE;
        return this;
    }

    public Settings setExitType(ExitType type) {
        this.exitType = type;
        return this;
    }

    public Settings disableGestures() {
        ++this.gesturesDisableCount;
        return this;
    }

    public Settings enableGestures() {
        --this.gesturesDisableCount;
        return this;
    }

    public Settings disableBounds() {
        ++this.boundsDisableCount;
        return this;
    }

    public Settings enableBounds() {
        --this.boundsDisableCount;
        return this;
    }

    @Deprecated
    public Settings setRestrictBounds(boolean restrict) {
        this.boundsDisableCount += restrict ? -1 : 1;
        if (this.boundsDisableCount < 0) {
            this.boundsDisableCount = 0;
        }
        return this;
    }

    public Settings setAnimationsDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Animations duration should be >= 0");
        }
        this.animationsDuration = duration;
        return this;
    }

    public int getViewportW() {
        return this.viewportW;
    }

    public int getViewportH() {
        return this.viewportH;
    }

    public int getMovementAreaW() {
        return this.isMovementAreaSpecified ? this.movementAreaW : this.viewportW;
    }

    public int getMovementAreaH() {
        return this.isMovementAreaSpecified ? this.movementAreaH : this.viewportH;
    }

    public int getImageW() {
        return this.imageW;
    }

    public int getImageH() {
        return this.imageH;
    }

    public float getMinZoom() {
        return this.minZoom;
    }

    public float getMaxZoom() {
        return this.maxZoom;
    }

    public float getDoubleTapZoom() {
        return this.doubleTapZoom;
    }

    public float getOverzoomFactor() {
        return this.overzoomFactor;
    }

    public float getOverscrollDistanceX() {
        return this.overscrollDistanceX;
    }

    public float getOverscrollDistanceY() {
        return this.overscrollDistanceY;
    }

    public boolean isFillViewport() {
        return this.isFillViewport;
    }

    public int getGravity() {
        return this.gravity;
    }

    public Fit getFitMethod() {
        return this.fitMethod;
    }

    public Bounds getBoundsType() {
        return this.boundsType;
    }

    public boolean isPanEnabled() {
        return this.isGesturesEnabled() && this.isPanEnabled;
    }

    public boolean isFlingEnabled() {
        return this.isGesturesEnabled() && this.isFlingEnabled;
    }

    public boolean isZoomEnabled() {
        return this.isGesturesEnabled() && this.isZoomEnabled;
    }

    public boolean isRotationEnabled() {
        return this.isGesturesEnabled() && this.isRotationEnabled;
    }

    public boolean isRestrictRotation() {
        return this.isRestrictRotation;
    }

    public boolean isDoubleTapEnabled() {
        return this.isGesturesEnabled() && this.isDoubleTapEnabled;
    }

    public boolean isExitEnabled() {
        return this.getExitType() != ExitType.NONE;
    }

    public ExitType getExitType() {
        return this.isGesturesEnabled() ? this.exitType : ExitType.NONE;
    }

    public boolean isGesturesEnabled() {
        return this.gesturesDisableCount <= 0;
    }

    public boolean isRestrictBounds() {
        return this.boundsDisableCount <= 0;
    }

    public long getAnimationsDuration() {
        return this.animationsDuration;
    }

    public boolean isEnabled() {
        return this.isGesturesEnabled() && (this.isPanEnabled || this.isZoomEnabled || this.isRotationEnabled || this.isDoubleTapEnabled);
    }

    public boolean hasImageSize() {
        return this.imageW != 0 && this.imageH != 0;
    }

    public boolean hasViewportSize() {
        return this.viewportW != 0 && this.viewportH != 0;
    }

    public static enum ExitType {
        ALL,
        SCROLL,
        ZOOM,
        NONE;

    }

    public static enum Bounds {
        NORMAL,
        INSIDE,
        OUTSIDE,
        PIVOT,
        NONE;

    }

    public static enum Fit {
        HORIZONTAL,
        VERTICAL,
        INSIDE,
        OUTSIDE,
        NONE;

    }
}

