/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewPager;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import com.alexvasilkov.gestures.GestureController;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.internal.detectors.RotationGestureDetector;

public class GestureControllerForPager
extends GestureController {
    private static final float SCROLL_THRESHOLD = 15.0f;
    private static final float OVERSCROLL_THRESHOLD_FACTOR = 4.0f;
    private static final Matrix tmpMatrix = new Matrix();
    private static final RectF tmpRectF = new RectF();
    private static final View.OnTouchListener PAGER_TOUCH_LISTENER = new View.OnTouchListener(){
        private boolean isTouchInProgress;

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouch(View view, @NonNull MotionEvent event) {
            if (!this.isTouchInProgress && event.getActionMasked() == 0) {
                this.isTouchInProgress = true;
                view.dispatchTouchEvent(event);
                this.isTouchInProgress = false;
                return true;
            }
            GestureControllerForPager.settleViewPagerIfFinished((ViewPager)view, event);
            return true;
        }
    };
    private final int touchSlop;
    private ViewPager viewPager;
    private boolean isViewPagerDisabled;
    private boolean isScrollGestureDetected;
    private boolean isSkipViewPager;
    private int viewPagerX;
    private float viewPagerSkippedX;
    private boolean isViewPagerInterceptedScroll;
    private float lastViewPagerEventX;

    public GestureControllerForPager(@NonNull View view) {
        super(view);
        this.touchSlop = ViewConfiguration.get((Context)view.getContext()).getScaledTouchSlop();
    }

    public void enableScrollInViewPager(ViewPager pager) {
        this.viewPager = pager;
        pager.setOnTouchListener(PAGER_TOUCH_LISTENER);
        pager.setMotionEventSplittingEnabled(false);
    }

    public void disableViewPager(boolean disable) {
        this.isViewPagerDisabled = disable;
    }

    @Override
    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(@NonNull View view, @NonNull MotionEvent event) {
        boolean result = super.onTouch(view, event);
        return this.viewPager != null || result;
    }

    @Override
    protected boolean onTouchInternal(@NonNull View view, @NonNull MotionEvent event) {
        if (this.viewPager == null) {
            return super.onTouchInternal(view, event);
        }
        MotionEvent pagerEvent = MotionEvent.obtain((MotionEvent)event);
        GestureControllerForPager.transformToPagerEvent(pagerEvent, view, this.viewPager);
        this.handleTouch(pagerEvent);
        boolean result = super.onTouchInternal(view, pagerEvent);
        pagerEvent.recycle();
        return result;
    }

    @Override
    protected boolean shouldDisallowInterceptTouch(MotionEvent event) {
        return this.viewPager != null || super.shouldDisallowInterceptTouch(event);
    }

    private void handleTouch(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 5: {
                if (event.getPointerCount() != 2) break;
                this.isSkipViewPager = !this.hasViewPagerX();
                break;
            }
        }
    }

    @Override
    protected boolean onDown(@NonNull MotionEvent event) {
        if (this.viewPager == null) {
            return super.onDown(event);
        }
        this.isSkipViewPager = false;
        this.isViewPagerInterceptedScroll = false;
        this.isScrollGestureDetected = false;
        this.viewPagerX = this.computeInitialViewPagerScroll(event);
        this.lastViewPagerEventX = event.getX();
        this.viewPagerSkippedX = 0.0f;
        this.passEventToViewPager(event);
        return super.onDown(event);
    }

    @Override
    protected void onUpOrCancel(@NonNull MotionEvent event) {
        this.passEventToViewPager(event);
        super.onUpOrCancel(event);
    }

    @Override
    protected boolean onScroll(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float dx, float dy) {
        if (this.viewPager == null) {
            return super.onScroll(e1, e2, dx, dy);
        }
        if (!this.isScrollGestureDetected) {
            this.isScrollGestureDetected = true;
            return true;
        }
        float fixedDistanceX = -this.scrollBy(e2, -dx);
        float fixedDistanceY = this.hasViewPagerX() ? 0.0f : dy;
        return super.onScroll(e1, e2, fixedDistanceX, fixedDistanceY);
    }

    @Override
    protected boolean onFling(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float vx, float vy) {
        return !this.hasViewPagerX() && super.onFling(e1, e2, vx, vy);
    }

    @Override
    protected boolean onScaleBegin(@NonNull ScaleGestureDetector detector) {
        return !this.hasViewPagerX() && super.onScaleBegin(detector);
    }

    @Override
    protected boolean onRotationBegin(@NonNull RotationGestureDetector detector) {
        return !this.hasViewPagerX() && super.onRotationBegin(detector);
    }

    @Override
    protected boolean onDoubleTapEvent(@NonNull MotionEvent event) {
        return !this.hasViewPagerX() && super.onDoubleTapEvent(event);
    }

    private float scrollBy(@NonNull MotionEvent event, float dx) {
        if (this.isSkipViewPager || this.isViewPagerDisabled) {
            return dx;
        }
        State state = this.getState();
        this.getStateController().getMovementArea(state, tmpRectF);
        float pagerDx = this.splitPagerScroll(dx, state, tmpRectF);
        pagerDx = this.skipPagerMovement(pagerDx, state, tmpRectF);
        float viewDx = dx - pagerDx;
        boolean shouldFixViewX = this.isViewPagerInterceptedScroll && this.viewPagerX == 0;
        int actualX = this.performViewPagerScroll(event, pagerDx);
        this.viewPagerX += actualX;
        if (shouldFixViewX) {
            viewDx += (float)(Math.round(pagerDx) - actualX);
        }
        return viewDx;
    }

    private float splitPagerScroll(float dx, State state, RectF movBounds) {
        if (this.getSettings().isPanEnabled()) {
            float availablePagerX;
            float dir = Math.signum(dx);
            float movementX = Math.abs(dx);
            float viewX = state.getX();
            float availableViewX = dir < 0.0f ? viewX - movBounds.left : movBounds.right - viewX;
            float f = availablePagerX = dir * (float)this.viewPagerX < 0.0f ? (float)Math.abs(this.viewPagerX) : 0.0f;
            if (availableViewX < 0.0f) {
                availableViewX = 0.0f;
            }
            float pagerMovementX = availablePagerX >= movementX ? movementX : (availableViewX + availablePagerX >= movementX ? availablePagerX : movementX - availableViewX);
            return pagerMovementX * dir;
        }
        return dx;
    }

    private float skipPagerMovement(float pagerDx, State state, RectF movBounds) {
        float overscrollDist = this.getSettings().getOverscrollDistanceY() * 4.0f;
        float overscrollThreshold = 0.0f;
        if (state.getY() < movBounds.top) {
            overscrollThreshold = (movBounds.top - state.getY()) / overscrollDist;
        } else if (state.getY() > movBounds.bottom) {
            overscrollThreshold = (state.getY() - movBounds.bottom) / overscrollDist;
        }
        float minZoom = this.getStateController().getFitZoom(state);
        float zoomThreshold = minZoom == 0.0f ? 0.0f : state.getZoom() / minZoom - 1.0f;
        float pagerThreshold = Math.max(overscrollThreshold, zoomThreshold);
        pagerThreshold = (float)Math.sqrt(Math.max(0.0f, Math.min(pagerThreshold, 1.0f)));
        pagerThreshold *= 15.0f * (float)this.touchSlop;
        if (this.viewPagerSkippedX * pagerDx < 0.0f && this.viewPagerX == 0) {
            this.viewPagerSkippedX = 0.0f;
        }
        if (this.hasViewPagerX()) {
            this.viewPagerSkippedX = pagerThreshold * Math.signum(this.viewPagerX);
        }
        if (Math.abs(this.viewPagerSkippedX) < pagerThreshold && pagerDx * this.viewPagerSkippedX >= 0.0f) {
            this.viewPagerSkippedX += pagerDx;
            float over = Math.abs(this.viewPagerSkippedX) - pagerThreshold;
            over = Math.max(0.0f, over) * Math.signum(pagerDx);
            this.viewPagerSkippedX -= over;
            return over;
        }
        return pagerDx;
    }

    private int computeInitialViewPagerScroll(MotionEvent downEvent) {
        int scroll;
        int pageWidth = this.viewPager.getWidth() + this.viewPager.getPageMargin();
        for (scroll = this.viewPager.getScrollX(); scroll < 0; scroll += pageWidth) {
        }
        int touchedItem = (int)(((float)scroll + downEvent.getX()) / (float)pageWidth);
        return pageWidth * touchedItem - scroll;
    }

    private boolean hasViewPagerX() {
        return this.viewPagerX < -1 || this.viewPagerX > 1;
    }

    private int performViewPagerScroll(@NonNull MotionEvent event, float pagerDx) {
        int scrollBegin = this.viewPager.getScrollX();
        this.lastViewPagerEventX += pagerDx;
        this.passEventToViewPager(event);
        return scrollBegin - this.viewPager.getScrollX();
    }

    private void passEventToViewPager(@NonNull MotionEvent event) {
        if (this.viewPager == null) {
            return;
        }
        MotionEvent fixedEvent = GestureControllerForPager.obtainOnePointerEvent(event);
        fixedEvent.setLocation(this.lastViewPagerEventX, 0.0f);
        if (this.isViewPagerInterceptedScroll) {
            this.viewPager.onTouchEvent(fixedEvent);
        } else {
            this.isViewPagerInterceptedScroll = this.viewPager.onInterceptTouchEvent(fixedEvent);
        }
        if (!this.isViewPagerInterceptedScroll && this.hasViewPagerX()) {
            GestureControllerForPager.settleViewPagerIfFinished(this.viewPager, event);
        }
        try {
            if (this.viewPager != null && this.viewPager.isFakeDragging()) {
                this.viewPager.endFakeDrag();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        fixedEvent.recycle();
    }

    private static MotionEvent obtainOnePointerEvent(@NonNull MotionEvent event) {
        return MotionEvent.obtain((long)event.getDownTime(), (long)event.getEventTime(), (int)event.getAction(), (float)event.getX(), (float)event.getY(), (int)event.getMetaState());
    }

    private static void settleViewPagerIfFinished(ViewPager pager, @NonNull MotionEvent event) {
        if (event.getActionMasked() == 1 || event.getActionMasked() == 3) {
            try {
                pager.beginFakeDrag();
                if (pager.isFakeDragging()) {
                    pager.endFakeDrag();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void transformToPagerEvent(MotionEvent event, View view, ViewPager pager) {
        tmpMatrix.reset();
        GestureControllerForPager.transformMatrixToPager(tmpMatrix, view, pager);
        event.transform(tmpMatrix);
    }

    private static void transformMatrixToPager(Matrix matrix, View view, ViewPager pager) {
        if (view.getParent() instanceof View) {
            View parent = (View)view.getParent();
            if (parent != pager) {
                GestureControllerForPager.transformMatrixToPager(matrix, parent, pager);
            }
            matrix.preTranslate((float)(-parent.getScrollX()), (float)(-parent.getScrollY()));
        }
        matrix.preTranslate((float)view.getLeft(), (float)view.getTop());
        matrix.preConcat(view.getMatrix());
    }
}

