/*
 * Decompiled with CFR 0.152.
 */
package com.alexvasilkov.gestures;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.widget.OverScroller;
import com.alexvasilkov.gestures.Settings;
import com.alexvasilkov.gestures.State;
import com.alexvasilkov.gestures.StateController;
import com.alexvasilkov.gestures.internal.AnimationEngine;
import com.alexvasilkov.gestures.internal.ExitController;
import com.alexvasilkov.gestures.internal.MovementBounds;
import com.alexvasilkov.gestures.internal.detectors.RotationGestureDetector;
import com.alexvasilkov.gestures.internal.detectors.ScaleGestureDetectorFixed;
import com.alexvasilkov.gestures.utils.FloatScroller;
import com.alexvasilkov.gestures.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;

public class GestureController
implements View.OnTouchListener {
    private static final float FLING_COEFFICIENT = 0.9f;
    private static final PointF tmpPointF = new PointF();
    private static final RectF tmpRectF = new RectF();
    private static final float[] tmpPointArr = new float[2];
    private final int touchSlop;
    private final int minVelocity;
    private final int maxVelocity;
    private OnGestureListener gestureListener;
    private OnStateSourceChangeListener sourceListener;
    private final List<OnStateChangeListener> stateListeners = new ArrayList<OnStateChangeListener>();
    private final AnimationEngine animationEngine;
    private final GestureDetector gestureDetector;
    private final ScaleGestureDetector scaleDetector;
    private final RotationGestureDetector rotateDetector;
    private boolean isInterceptTouchCalled;
    private boolean isInterceptTouchDisallowed;
    private boolean isScrollDetected;
    private boolean isScaleDetected;
    private boolean isRotationDetected;
    private float pivotX = Float.NaN;
    private float pivotY = Float.NaN;
    private float endPivotX = Float.NaN;
    private float endPivotY = Float.NaN;
    private boolean isStateChangedDuringTouch;
    private boolean isRestrictZoomRequested;
    private boolean isRestrictRotationRequested;
    private boolean isAnimatingInBounds;
    private StateSource stateSource = StateSource.NONE;
    private final OverScroller flingScroller;
    private final FloatScroller stateScroller;
    private final MovementBounds flingBounds;
    private final State stateStart = new State();
    private final State stateEnd = new State();
    private final View targetView;
    private final Settings settings;
    private final State state = new State();
    private final State prevState = new State();
    private final StateController stateController;
    private final ExitController exitController;

    public GestureController(@NonNull View view) {
        Context context = view.getContext();
        this.targetView = view;
        this.settings = new Settings();
        this.stateController = new StateController(this.settings);
        this.animationEngine = new LocalAnimationEngine(view);
        InternalGesturesListener internalListener = new InternalGesturesListener();
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)internalListener);
        this.scaleDetector = new ScaleGestureDetectorFixed(context, internalListener);
        this.rotateDetector = new RotationGestureDetector(context, internalListener);
        this.exitController = new ExitController(view, this);
        this.flingScroller = new OverScroller(context);
        this.stateScroller = new FloatScroller();
        this.flingBounds = new MovementBounds(this.settings);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.touchSlop = configuration.getScaledTouchSlop();
        this.minVelocity = configuration.getScaledMinimumFlingVelocity();
        this.maxVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    public void setOnGesturesListener(@Nullable OnGestureListener listener) {
        this.gestureListener = listener;
    }

    public void setOnStateSourceChangeListener(@Nullable OnStateSourceChangeListener listener) {
        this.sourceListener = listener;
    }

    public void addOnStateChangeListener(@NonNull OnStateChangeListener listener) {
        this.stateListeners.add(listener);
    }

    public void removeOnStateChangeListener(OnStateChangeListener listener) {
        this.stateListeners.remove(listener);
    }

    @Deprecated
    public void setLongPressEnabled(boolean enabled) {
        this.targetView.setLongClickable(true);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public State getState() {
        return this.state;
    }

    public StateController getStateController() {
        return this.stateController;
    }

    public void updateState() {
        this.stateController.applyZoomPatch(this.state);
        this.stateController.applyZoomPatch(this.prevState);
        this.stateController.applyZoomPatch(this.stateStart);
        this.stateController.applyZoomPatch(this.stateEnd);
        this.exitController.applyZoomPatch();
        boolean reset = this.stateController.updateState(this.state);
        if (reset) {
            this.notifyStateReset();
        } else {
            this.notifyStateUpdated();
        }
    }

    public void resetState() {
        this.stopAllAnimations();
        boolean reset = this.stateController.resetState(this.state);
        if (reset) {
            this.notifyStateReset();
        } else {
            this.notifyStateUpdated();
        }
    }

    public void setPivot(float pivotX, float pivotY) {
        this.pivotX = pivotX;
        this.pivotY = pivotY;
    }

    public boolean animateKeepInBounds() {
        return this.animateStateTo(this.state, true);
    }

    public boolean animateStateTo(@Nullable State endState) {
        return this.animateStateTo(endState, true);
    }

    private boolean animateStateTo(@Nullable State endState, boolean keepInBounds) {
        if (endState == null) {
            return false;
        }
        State endStateRestricted = null;
        if (keepInBounds) {
            endStateRestricted = this.stateController.restrictStateBoundsCopy(endState, this.prevState, this.pivotX, this.pivotY, false, false, true);
        }
        if (endStateRestricted == null) {
            endStateRestricted = endState;
        }
        if (endStateRestricted.equals(this.state)) {
            return false;
        }
        this.stopAllAnimations();
        this.isAnimatingInBounds = keepInBounds;
        this.stateStart.set(this.state);
        this.stateEnd.set(endStateRestricted);
        if (!Float.isNaN(this.pivotX) && !Float.isNaN(this.pivotY)) {
            GestureController.tmpPointArr[0] = this.pivotX;
            GestureController.tmpPointArr[1] = this.pivotY;
            MathUtils.computeNewPosition(tmpPointArr, this.stateStart, this.stateEnd);
            this.endPivotX = tmpPointArr[0];
            this.endPivotY = tmpPointArr[1];
        }
        this.stateScroller.setDuration(this.settings.getAnimationsDuration());
        this.stateScroller.startScroll(0.0f, 1.0f);
        this.animationEngine.start();
        this.notifyStateSourceChanged();
        return true;
    }

    public boolean isAnimatingState() {
        return !this.stateScroller.isFinished();
    }

    public boolean isAnimatingFling() {
        return !this.flingScroller.isFinished();
    }

    public boolean isAnimating() {
        return this.isAnimatingState() || this.isAnimatingFling();
    }

    public void stopStateAnimation() {
        if (this.isAnimatingState()) {
            this.stateScroller.forceFinished();
            this.onStateAnimationFinished(true);
        }
    }

    public void stopFlingAnimation() {
        if (this.isAnimatingFling()) {
            this.flingScroller.forceFinished(true);
            this.onFlingAnimationFinished(true);
        }
    }

    public void stopAllAnimations() {
        this.stopStateAnimation();
        this.stopFlingAnimation();
    }

    protected void onStateAnimationFinished(boolean forced) {
        this.isAnimatingInBounds = false;
        this.pivotX = Float.NaN;
        this.pivotY = Float.NaN;
        this.notifyStateSourceChanged();
    }

    protected void onFlingAnimationFinished(boolean forced) {
        if (!forced) {
            this.animateKeepInBounds();
        }
        this.notifyStateSourceChanged();
    }

    protected void notifyStateUpdated() {
        this.prevState.set(this.state);
        for (OnStateChangeListener listener : this.stateListeners) {
            listener.onStateChanged(this.state);
        }
    }

    protected void notifyStateReset() {
        this.exitController.stopDetection();
        for (OnStateChangeListener listener : this.stateListeners) {
            listener.onStateReset(this.prevState, this.state);
        }
        this.notifyStateUpdated();
    }

    private void notifyStateSourceChanged() {
        StateSource type = StateSource.NONE;
        if (this.isAnimating()) {
            type = StateSource.ANIMATION;
        } else if (this.isScrollDetected || this.isScaleDetected || this.isRotationDetected) {
            type = StateSource.USER;
        }
        if (this.stateSource != type) {
            this.stateSource = type;
            if (this.sourceListener != null) {
                this.sourceListener.onStateSourceChanged(type);
            }
        }
    }

    public boolean onInterceptTouch(@NonNull View view, @NonNull MotionEvent event) {
        this.isInterceptTouchCalled = true;
        return this.onTouchInternal(view, event);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(@NonNull View view, @NonNull MotionEvent event) {
        if (!this.isInterceptTouchCalled) {
            this.onTouchInternal(view, event);
        }
        this.isInterceptTouchCalled = false;
        return this.settings.isEnabled();
    }

    protected boolean onTouchInternal(@NonNull View view, @NonNull MotionEvent event) {
        MotionEvent viewportEvent = MotionEvent.obtain((MotionEvent)event);
        viewportEvent.offsetLocation((float)(-view.getPaddingLeft()), (float)(-view.getPaddingTop()));
        this.gestureDetector.setIsLongpressEnabled(view.isLongClickable());
        boolean result = this.gestureDetector.onTouchEvent(viewportEvent);
        this.scaleDetector.onTouchEvent(viewportEvent);
        this.rotateDetector.onTouchEvent(viewportEvent);
        result = result || this.isScaleDetected || this.isRotationDetected;
        this.notifyStateSourceChanged();
        if (this.exitController.isExitDetected() && !this.state.equals(this.prevState)) {
            this.notifyStateUpdated();
        }
        if (this.isStateChangedDuringTouch) {
            this.isStateChangedDuringTouch = false;
            this.stateController.restrictStateBounds(this.state, this.prevState, this.pivotX, this.pivotY, true, true, false);
            if (!this.state.equals(this.prevState)) {
                this.notifyStateUpdated();
            }
        }
        if (this.isRestrictZoomRequested || this.isRestrictRotationRequested) {
            this.isRestrictZoomRequested = false;
            this.isRestrictRotationRequested = false;
            if (!this.exitController.isExitDetected()) {
                State restrictedState = this.stateController.restrictStateBoundsCopy(this.state, this.prevState, this.pivotX, this.pivotY, true, false, true);
                this.animateStateTo(restrictedState, false);
            }
        }
        if (viewportEvent.getActionMasked() == 1 || viewportEvent.getActionMasked() == 3) {
            this.onUpOrCancel(viewportEvent);
            this.notifyStateSourceChanged();
        }
        if (!this.isInterceptTouchDisallowed && this.shouldDisallowInterceptTouch(viewportEvent)) {
            this.isInterceptTouchDisallowed = true;
            ViewParent parent = view.getParent();
            if (parent != null) {
                parent.requestDisallowInterceptTouchEvent(true);
            }
        }
        viewportEvent.recycle();
        return result;
    }

    protected boolean shouldDisallowInterceptTouch(MotionEvent event) {
        if (this.exitController.isExitDetected()) {
            return true;
        }
        switch (event.getActionMasked()) {
            case 0: 
            case 2: {
                boolean isPannable;
                this.stateController.getMovementArea(this.state, tmpRectF);
                boolean bl = isPannable = State.compare(tmpRectF.width(), 0.0f) > 0 || State.compare(tmpRectF.height(), 0.0f) > 0;
                if (!this.settings.isPanEnabled() || !isPannable && this.settings.isRestrictBounds()) break;
                return true;
            }
            case 5: {
                return this.settings.isZoomEnabled() || this.settings.isRotationEnabled();
            }
        }
        return false;
    }

    protected boolean onDown(@NonNull MotionEvent event) {
        this.isInterceptTouchDisallowed = false;
        this.stopFlingAnimation();
        if (this.gestureListener != null) {
            this.gestureListener.onDown(event);
        }
        return false;
    }

    protected void onUpOrCancel(@NonNull MotionEvent event) {
        this.isScrollDetected = false;
        this.isScaleDetected = false;
        this.isRotationDetected = false;
        this.exitController.onUpOrCancel();
        if (!this.isAnimatingFling() && !this.isAnimatingInBounds) {
            this.animateKeepInBounds();
        }
        if (this.gestureListener != null) {
            this.gestureListener.onUpOrCancel(event);
        }
    }

    protected boolean onSingleTapUp(@NonNull MotionEvent event) {
        if (!this.settings.isDoubleTapEnabled()) {
            this.targetView.performClick();
        }
        return this.gestureListener != null && this.gestureListener.onSingleTapUp(event);
    }

    protected void onLongPress(@NonNull MotionEvent event) {
        if (this.settings.isEnabled()) {
            this.targetView.performLongClick();
            if (this.gestureListener != null) {
                this.gestureListener.onLongPress(event);
            }
        }
    }

    protected boolean onScroll(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float dx, float dy) {
        if (!this.settings.isPanEnabled() || this.isAnimatingState()) {
            return false;
        }
        boolean scrollConsumed = this.exitController.onScroll(-dx, -dy);
        if (scrollConsumed) {
            return true;
        }
        if (!this.isScrollDetected) {
            boolean bl = this.isScrollDetected = Math.abs(e2.getX() - e1.getX()) > (float)this.touchSlop || Math.abs(e2.getY() - e1.getY()) > (float)this.touchSlop;
            if (this.isScrollDetected) {
                return true;
            }
        }
        if (this.isScrollDetected) {
            this.state.translateBy(-dx, -dy);
            this.isStateChangedDuringTouch = true;
        }
        return this.isScrollDetected;
    }

    protected boolean onFling(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float vx, float vy) {
        if (!this.settings.isPanEnabled() || !this.settings.isFlingEnabled() || this.isAnimatingState()) {
            return false;
        }
        boolean flingConsumed = this.exitController.onFling();
        if (flingConsumed) {
            return true;
        }
        this.stopFlingAnimation();
        this.flingBounds.set(this.state).extend(this.state.getX(), this.state.getY());
        this.flingScroller.fling(Math.round(this.state.getX()), Math.round(this.state.getY()), this.limitFlingVelocity(vx * 0.9f), this.limitFlingVelocity(vy * 0.9f), Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.animationEngine.start();
        this.notifyStateSourceChanged();
        return true;
    }

    private int limitFlingVelocity(float velocity) {
        if (Math.abs(velocity) < (float)this.minVelocity) {
            return 0;
        }
        if (Math.abs(velocity) >= (float)this.maxVelocity) {
            return (int)Math.signum(velocity) * this.maxVelocity;
        }
        return Math.round(velocity);
    }

    protected boolean onFlingScroll(int dx, int dy) {
        float prevX = this.state.getX();
        float prevY = this.state.getY();
        float toX = prevX + (float)dx;
        float toY = prevY + (float)dy;
        if (this.settings.isRestrictBounds()) {
            this.flingBounds.restrict(toX, toY, tmpPointF);
            toX = GestureController.tmpPointF.x;
            toY = GestureController.tmpPointF.y;
        }
        this.state.translateTo(toX, toY);
        return !State.equals(prevX, toX) || !State.equals(prevY, toY);
    }

    protected boolean onSingleTapConfirmed(MotionEvent event) {
        if (this.settings.isDoubleTapEnabled()) {
            this.targetView.performClick();
        }
        return this.gestureListener != null && this.gestureListener.onSingleTapConfirmed(event);
    }

    protected boolean onDoubleTapEvent(MotionEvent event) {
        if (!this.settings.isDoubleTapEnabled()) {
            return false;
        }
        if (event.getActionMasked() != 1) {
            return false;
        }
        if (this.isScaleDetected) {
            return false;
        }
        if (this.gestureListener != null && this.gestureListener.onDoubleTap(event)) {
            return true;
        }
        this.animateStateTo(this.stateController.toggleMinMaxZoom(this.state, event.getX(), event.getY()));
        return true;
    }

    protected boolean onScaleBegin(ScaleGestureDetector detector) {
        this.isScaleDetected = this.settings.isZoomEnabled();
        if (this.isScaleDetected) {
            this.exitController.onScaleBegin();
        }
        return this.isScaleDetected;
    }

    protected boolean onScale(ScaleGestureDetector detector) {
        if (!this.settings.isZoomEnabled() || this.isAnimatingState()) {
            return false;
        }
        float scaleFactor = detector.getScaleFactor();
        boolean scaleConsumed = this.exitController.onScale(scaleFactor);
        if (scaleConsumed) {
            return true;
        }
        this.pivotX = detector.getFocusX();
        this.pivotY = detector.getFocusY();
        this.state.zoomBy(scaleFactor, this.pivotX, this.pivotY);
        this.isStateChangedDuringTouch = true;
        return true;
    }

    protected void onScaleEnd(ScaleGestureDetector detector) {
        if (this.isScaleDetected) {
            this.exitController.onScaleEnd();
        }
        this.isScaleDetected = false;
        this.isRestrictZoomRequested = true;
    }

    protected boolean onRotationBegin(RotationGestureDetector detector) {
        this.isRotationDetected = this.settings.isRotationEnabled();
        if (this.isRotationDetected) {
            this.exitController.onRotationBegin();
        }
        return this.isRotationDetected;
    }

    protected boolean onRotate(RotationGestureDetector detector) {
        if (!this.settings.isRotationEnabled() || this.isAnimatingState()) {
            return false;
        }
        boolean rotateConsumed = this.exitController.onRotate();
        if (rotateConsumed) {
            return true;
        }
        this.pivotX = detector.getFocusX();
        this.pivotY = detector.getFocusY();
        this.state.rotateBy(detector.getRotationDelta(), this.pivotX, this.pivotY);
        this.isStateChangedDuringTouch = true;
        return true;
    }

    protected void onRotationEnd(RotationGestureDetector detector) {
        if (this.isRotationDetected) {
            this.exitController.onRotationEnd();
        }
        this.isRotationDetected = false;
        this.isRestrictRotationRequested = true;
    }

    private class InternalGesturesListener
    implements GestureDetector.OnGestureListener,
    GestureDetector.OnDoubleTapListener,
    ScaleGestureDetector.OnScaleGestureListener,
    RotationGestureDetector.OnRotationGestureListener {
        private InternalGesturesListener() {
        }

        public boolean onSingleTapConfirmed(@NonNull MotionEvent event) {
            return GestureController.this.onSingleTapConfirmed(event);
        }

        public boolean onDoubleTap(@NonNull MotionEvent event) {
            return false;
        }

        public boolean onDoubleTapEvent(@NonNull MotionEvent event) {
            return GestureController.this.onDoubleTapEvent(event);
        }

        public boolean onDown(@NonNull MotionEvent event) {
            return GestureController.this.onDown(event);
        }

        public void onShowPress(@NonNull MotionEvent event) {
        }

        public boolean onSingleTapUp(@NonNull MotionEvent event) {
            return GestureController.this.onSingleTapUp(event);
        }

        public boolean onScroll(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float distanceX, float distanceY) {
            return GestureController.this.onScroll(e1, e2, distanceX, distanceY);
        }

        public void onLongPress(@NonNull MotionEvent event) {
            GestureController.this.onLongPress(event);
        }

        public boolean onFling(@NonNull MotionEvent e1, @NonNull MotionEvent e2, float velocityX, float velocityY) {
            return GestureController.this.onFling(e1, e2, velocityX, velocityY);
        }

        @Override
        public boolean onRotate(@NonNull RotationGestureDetector detector) {
            return GestureController.this.onRotate(detector);
        }

        @Override
        public boolean onRotationBegin(@NonNull RotationGestureDetector detector) {
            return GestureController.this.onRotationBegin(detector);
        }

        @Override
        public void onRotationEnd(@NonNull RotationGestureDetector detector) {
            GestureController.this.onRotationEnd(detector);
        }

        public boolean onScale(@NonNull ScaleGestureDetector detector) {
            return GestureController.this.onScale(detector);
        }

        public boolean onScaleBegin(@NonNull ScaleGestureDetector detector) {
            return GestureController.this.onScaleBegin(detector);
        }

        public void onScaleEnd(@NonNull ScaleGestureDetector detector) {
            GestureController.this.onScaleEnd(detector);
        }
    }

    public static class SimpleOnGestureListener
    implements OnGestureListener {
        @Override
        public void onDown(@NonNull MotionEvent event) {
        }

        @Override
        public void onUpOrCancel(@NonNull MotionEvent event) {
        }

        @Override
        public boolean onSingleTapUp(@NonNull MotionEvent event) {
            return false;
        }

        @Override
        public boolean onSingleTapConfirmed(@NonNull MotionEvent event) {
            return false;
        }

        @Override
        public void onLongPress(@NonNull MotionEvent event) {
        }

        @Override
        public boolean onDoubleTap(@NonNull MotionEvent event) {
            return false;
        }
    }

    public static interface OnGestureListener {
        public void onDown(@NonNull MotionEvent var1);

        public void onUpOrCancel(@NonNull MotionEvent var1);

        public boolean onSingleTapUp(@NonNull MotionEvent var1);

        public boolean onSingleTapConfirmed(@NonNull MotionEvent var1);

        public void onLongPress(@NonNull MotionEvent var1);

        public boolean onDoubleTap(@NonNull MotionEvent var1);
    }

    public static enum StateSource {
        NONE,
        USER,
        ANIMATION;

    }

    public static interface OnStateSourceChangeListener {
        public void onStateSourceChanged(StateSource var1);
    }

    public static interface OnStateChangeListener {
        public void onStateChanged(State var1);

        public void onStateReset(State var1, State var2);
    }

    private class LocalAnimationEngine
    extends AnimationEngine {
        LocalAnimationEngine(View view) {
            super(view);
        }

        @Override
        public boolean onStep() {
            boolean shouldProceed = false;
            if (GestureController.this.isAnimatingFling()) {
                int prevX = GestureController.this.flingScroller.getCurrX();
                int prevY = GestureController.this.flingScroller.getCurrY();
                if (GestureController.this.flingScroller.computeScrollOffset()) {
                    int dy;
                    int dx = GestureController.this.flingScroller.getCurrX() - prevX;
                    if (!GestureController.this.onFlingScroll(dx, dy = GestureController.this.flingScroller.getCurrY() - prevY)) {
                        GestureController.this.stopFlingAnimation();
                    }
                    shouldProceed = true;
                }
                if (!GestureController.this.isAnimatingFling()) {
                    GestureController.this.onFlingAnimationFinished(false);
                }
            }
            if (GestureController.this.isAnimatingState()) {
                GestureController.this.stateScroller.computeScroll();
                float factor = GestureController.this.stateScroller.getCurr();
                if (Float.isNaN(GestureController.this.pivotX) || Float.isNaN(GestureController.this.pivotY) || Float.isNaN(GestureController.this.endPivotX) || Float.isNaN(GestureController.this.endPivotY)) {
                    MathUtils.interpolate(GestureController.this.state, GestureController.this.stateStart, GestureController.this.stateEnd, factor);
                } else {
                    MathUtils.interpolate(GestureController.this.state, GestureController.this.stateStart, GestureController.this.pivotX, GestureController.this.pivotY, GestureController.this.stateEnd, GestureController.this.endPivotX, GestureController.this.endPivotY, factor);
                }
                shouldProceed = true;
                if (!GestureController.this.isAnimatingState()) {
                    GestureController.this.onStateAnimationFinished(false);
                }
            }
            if (shouldProceed) {
                GestureController.this.notifyStateUpdated();
            }
            return shouldProceed;
        }
    }
}

