/*
 * Decompiled with CFR 0.152.
 */
package com.alexnederlof.jasperreport;

import com.alexnederlof.jasperreport.CompileTask;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRJdtCompiler;
import org.apache.commons.lang.Validate;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class JasperReporter
extends AbstractMojo {
    static final String ERROR_JRE_COMPILE_ERROR = "Some Jasper reports could not be compiled. See log above for details.";
    private String compiler;
    private File outputDirectory;
    private File sourceDirectory;
    private String sourceFileExt;
    private String outputFileExt;
    private boolean xmlValidation;
    private boolean verbose;
    private int numberOfThreads;
    private Log log;

    public void execute() throws MojoExecutionException {
        this.log = this.getLog();
        if (this.outputDirectory.exists() && this.outputDirectory.listFiles().length > 0) {
            this.log.info((CharSequence)"It seems the Jasper reports are already compiled. If you want to re-compile, run maven with the 'clean' goal.");
            return;
        }
        if (this.verbose) {
            this.logConfiguration(this.log);
        }
        this.checkOutDirWritable(this.outputDirectory);
        this.configureJasper();
        List<CompileTask> tasks = this.generateTasks(this.sourceDirectory, this.outputDirectory);
        if (tasks.isEmpty()) {
            this.log.info((CharSequence)"Nothing to compile");
            return;
        }
        this.executeTasks(tasks);
    }

    private void logConfiguration(Log log) {
        log.info((CharSequence)"Generating Jasper reports");
        log.info((CharSequence)("Outputdir=" + this.outputDirectory.getAbsolutePath()));
        log.info((CharSequence)("Sourcedir=" + this.sourceDirectory.getAbsolutePath()));
        log.info((CharSequence)("Output ext=" + this.outputFileExt));
        log.info((CharSequence)("Source ext=" + this.sourceFileExt));
        log.info((CharSequence)("XML Validation=" + this.xmlValidation));
        log.info((CharSequence)("JasperReports Compiler=" + this.compiler));
        log.info((CharSequence)("Number of threads:" + this.numberOfThreads));
    }

    private void checkOutDirWritable(File outputDirectory) throws MojoExecutionException {
        if (outputDirectory.exists()) {
            if (outputDirectory.canWrite()) {
                return;
            }
            throw new MojoExecutionException("The output dir exists but was not writable. Try running maven with the 'clean' goal.");
        }
        this.checkIfOutpuCanBeCreated();
        this.checkIfOutputDirIsWritable();
        if (this.verbose) {
            this.getLog().info((CharSequence)"Output dir check OK");
        }
    }

    private void configureJasper() {
        DefaultJasperReportsContext jasperReportsContext = DefaultJasperReportsContext.getInstance();
        jasperReportsContext.setProperty("net.sf.jasperreports.compiler.xml.validation", String.valueOf(this.xmlValidation));
        jasperReportsContext.setProperty("net.sf.jasperreports.compiler.", this.compiler == null ? JRJdtCompiler.class.getName() : this.compiler);
        jasperReportsContext.setProperty("net.sf.jasperreports.compiler.keep.java.file", Boolean.FALSE.toString());
    }

    private void checkIfOutpuCanBeCreated() throws MojoExecutionException {
        if (!this.outputDirectory.mkdirs()) {
            throw new MojoExecutionException((Object)this, "Output folder could not be created", "Outputfolder " + this.outputDirectory.getAbsolutePath() + " is not a folder");
        }
    }

    private void checkIfOutputDirIsWritable() throws MojoExecutionException {
        if (!this.outputDirectory.canWrite()) {
            throw new MojoExecutionException((Object)this, "Could not write to output folder", "Could not write to output folder: " + this.outputDirectory.getAbsolutePath());
        }
    }

    private List<CompileTask> generateTasks(File sourceDirectory, File destinationDirectory) {
        Validate.isTrue((boolean)sourceDirectory.isDirectory(), (String)(sourceDirectory.getName() + " is not a directory"));
        LinkedList<CompileTask> tasks = new LinkedList<CompileTask>();
        for (File f : sourceDirectory.listFiles()) {
            this.generateTasks(destinationDirectory, tasks, f);
        }
        return tasks;
    }

    private void generateTasks(File destinationDirectory, List<CompileTask> tasks, File f) {
        if (f.isDirectory()) {
            tasks.addAll(this.generateTasks(f, this.createNewDest(f, destinationDirectory)));
        } else if (f.getName().endsWith(this.sourceFileExt)) {
            tasks.add(new CompileTask(f, destinationDirectory, this.sourceFileExt, this.outputFileExt, this.log, this.verbose));
        } else if (this.verbose) {
            this.log.info((CharSequence)("Skipped " + f.getName() + " because it doesnt have the extension " + this.sourceFileExt));
        }
    }

    private File createNewDest(File origin, File destinationDirectory) {
        File newDest = new File(destinationDirectory, origin.getName());
        newDest.mkdir();
        return newDest;
    }

    private void executeTasks(List<CompileTask> tasks) throws MojoExecutionException {
        try {
            long t1 = System.currentTimeMillis();
            List<Future<Void>> output = Executors.newFixedThreadPool(this.numberOfThreads).invokeAll(tasks);
            long time = System.currentTimeMillis() - t1;
            this.getLog().info((CharSequence)("Generated " + output.size() + " jasper reports in " + (double)time / 1000.0 + " seconds"));
            this.checkForExceptions(output);
        }
        catch (InterruptedException e) {
            this.log.error((CharSequence)"Failed to compile Japser reports: Interrupted!", (Throwable)e);
            throw new MojoExecutionException("Error while compiling Jasper reports", (Exception)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof JRException) {
                throw new MojoExecutionException(ERROR_JRE_COMPILE_ERROR, (Exception)e);
            }
            throw new MojoExecutionException("Error while compiling Jasper reports", (Exception)e);
        }
    }

    private void checkForExceptions(List<Future<Void>> output) throws InterruptedException, ExecutionException {
        for (Future<Void> future : output) {
            future.get();
        }
    }
}

