/*
 * Decompiled with CFR 0.152.
 */
package com.alexkasko.springjdbc.iterable;

import com.alexkasko.springjdbc.iterable.CloseableIterator;
import com.alexkasko.springjdbc.iterable.IterableJdbcOperations;
import com.alexkasko.springjdbc.iterable.PreparedStatementCloseableIterator;
import com.alexkasko.springjdbc.iterable.StatementCloseableIterator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ParameterDisposer;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.SqlProvider;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.Assert;

public class IterableJdbcTemplate
extends JdbcTemplate
implements IterableJdbcOperations {
    private static final Log logger = LogFactory.getLog(IterableJdbcTemplate.class);

    public IterableJdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public IterableJdbcTemplate(DataSource dataSource, int fetchSize) {
        this(dataSource);
        this.setFetchSize(fetchSize);
    }

    @Deprecated
    public static void closeQuetly(CloseableIterator<?> iter) {
        try {
            if (iter != null) {
                iter.close();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Error on closing iterator: [" + iter + "]"), (Throwable)e);
        }
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryForIter(psc, null, rowMapper);
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(PreparedStatementCreator psc, PreparedStatementSetter pss, RowMapper<T> rowMapper) throws DataAccessException {
        Assert.notNull((Object)psc, (String)"PreparedStatementCreator must not be null");
        Assert.notNull(rowMapper, (String)"RowMapper must not be null");
        if (logger.isDebugEnabled()) {
            String sql = IterableJdbcTemplate.getSql(psc);
            logger.debug((Object)("Executing prepared SQL statement" + (sql != null ? " [" + sql + "]" : "")));
        }
        DataSource ds = this.getDataSource();
        Connection con = DataSourceUtils.getConnection((DataSource)ds);
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Connection conToUse = con;
            NativeJdbcExtractor nje = this.getNativeJdbcExtractor();
            if (nje != null && nje.isNativeConnectionNecessaryForNativePreparedStatements()) {
                conToUse = nje.getNativeConnection(con);
            }
            ps = psc.createPreparedStatement(conToUse);
            this.applyStatementSettings(ps);
            PreparedStatement psToUse = ps;
            if (nje != null) {
                psToUse = nje.getNativePreparedStatement(ps);
            }
            if (pss != null) {
                pss.setValues(psToUse);
            }
            ResultSet rsToUse = rs = psToUse.executeQuery();
            if (nje != null) {
                rsToUse = nje.getNativeResultSet(rs);
            }
            this.handleWarnings(ps);
            return new PreparedStatementCloseableIterator<T>(ds, con, psc, pss, ps, rs, rsToUse, rowMapper);
        }
        catch (SQLException ex) {
            if (psc instanceof ParameterDisposer) {
                ((ParameterDisposer)psc).cleanupParameters();
            }
            String sql = IterableJdbcTemplate.getSql(psc);
            psc = null;
            JdbcUtils.closeResultSet(rs);
            rs = null;
            JdbcUtils.closeStatement((Statement)ps);
            ps = null;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
            con = null;
            throw this.getExceptionTranslator().translate("PreparedStatementCallback", sql, ex);
        }
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(String sql, RowMapper<T> rowMapper) throws DataAccessException {
        Assert.hasText((String)sql, (String)"Provided sql query is blank");
        Assert.notNull(rowMapper, (String)"RowMapper must not be null");
        DataSource ds = this.getDataSource();
        Connection con = DataSourceUtils.getConnection((DataSource)ds);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Connection conToUse = con;
            NativeJdbcExtractor nje = this.getNativeJdbcExtractor();
            if (nje != null && nje.isNativeConnectionNecessaryForNativeStatements()) {
                conToUse = nje.getNativeConnection(con);
            }
            stmt = conToUse.createStatement();
            this.applyStatementSettings(stmt);
            Statement stmtToUse = stmt;
            if (nje != null) {
                stmtToUse = nje.getNativeStatement(stmt);
            }
            ResultSet rsToUse = rs = stmtToUse.executeQuery(sql);
            if (nje != null) {
                rsToUse = nje.getNativeResultSet(rs);
            }
            this.handleWarnings(stmt);
            return new StatementCloseableIterator<T>(ds, con, stmt, rs, rsToUse, rowMapper);
        }
        catch (SQLException ex) {
            JdbcUtils.closeResultSet(rs);
            rs = null;
            JdbcUtils.closeStatement(stmt);
            stmt = null;
            DataSourceUtils.releaseConnection((Connection)con, (DataSource)this.getDataSource());
            con = null;
            throw this.getExceptionTranslator().translate("StatementCallback", IterableJdbcTemplate.getSql(sql), ex);
        }
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(String sql, Class<T> elementType) throws DataAccessException {
        return this.queryForIter(sql, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public CloseableIterator<Map<String, Object>> queryForIter(String sql) throws DataAccessException {
        return this.queryForIter(sql, this.getColumnMapRowMapper());
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(String sql, PreparedStatementSetter pss, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryForIter(new SimplePreparedStatementCreator(sql), pss, rowMapper);
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(String sql, Object[] args, int[] argTypes, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryForIter(sql, this.newArgTypePreparedStatementSetter(args, argTypes), rowMapper);
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(String sql, Object[] args, RowMapper<T> rowMapper) throws DataAccessException {
        return this.queryForIter(sql, this.newArgPreparedStatementSetter(args), rowMapper);
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(String sql, RowMapper<T> rowMapper, Object ... args) throws DataAccessException {
        return this.queryForIter(sql, this.newArgPreparedStatementSetter(args), rowMapper);
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(String sql, Object[] args, int[] argTypes, Class<T> elementType) throws DataAccessException {
        return this.queryForIter(sql, args, argTypes, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(String sql, Object[] args, Class<T> elementType) throws DataAccessException {
        return this.queryForIter(sql, args, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public <T> CloseableIterator<T> queryForIter(String sql, Class<T> elementType, Object ... args) throws DataAccessException {
        return this.queryForIter(sql, args, this.getSingleColumnRowMapper(elementType));
    }

    @Override
    public CloseableIterator<Map<String, Object>> queryForIter(String sql, Object[] args, int[] argTypes) throws DataAccessException {
        return this.queryForIter(sql, args, argTypes, this.getColumnMapRowMapper());
    }

    @Override
    public CloseableIterator<Map<String, Object>> queryForIter(String sql, Object ... args) throws DataAccessException {
        return this.queryForIter(sql, args, this.getColumnMapRowMapper());
    }

    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    SqlProvider {
        private final String sql;

        public SimplePreparedStatementCreator(String sql) {
            Assert.notNull((Object)sql, (String)"SQL must not be null");
            this.sql = sql;
        }

        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return con.prepareStatement(this.sql);
        }

        public String getSql() {
            return this.sql;
        }
    }
}

