/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.gatt;

import java.util.concurrent.atomic.AtomicBoolean;

public abstract class GattInterface {
    public abstract boolean connect(String var1, boolean var2);

    public abstract void disconnect(String var1);

    public abstract boolean discoverServices(String var1);

    public abstract boolean read(String var1, String var2, String var3);

    public abstract boolean write(String var1, String var2, String var3, byte[] var4);

    public abstract void clearGatt();

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class CppProxy
    extends GattInterface {
        private final long nativeRef;
        private final AtomicBoolean a = new AtomicBoolean(false);

        private CppProxy(long l2) {
            if (l2 == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = l2;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean bl = this.a.getAndSet(true);
            if (!bl) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public boolean connect(String string2, boolean bl) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_connect(this.nativeRef, string2, bl);
        }

        private native boolean native_connect(long var1, String var3, boolean var4);

        @Override
        public void disconnect(String string2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_disconnect(this.nativeRef, string2);
        }

        private native void native_disconnect(long var1, String var3);

        @Override
        public boolean discoverServices(String string2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_discoverServices(this.nativeRef, string2);
        }

        private native boolean native_discoverServices(long var1, String var3);

        @Override
        public boolean read(String string2, String string3, String string4) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_read(this.nativeRef, string2, string3, string4);
        }

        private native boolean native_read(long var1, String var3, String var4, String var5);

        @Override
        public boolean write(String string2, String string3, String string4, byte[] byArray) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_write(this.nativeRef, string2, string3, string4, byArray);
        }

        private native boolean native_write(long var1, String var3, String var4, String var5, byte[] var6);

        @Override
        public void clearGatt() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_clearGatt(this.nativeRef);
        }

        private native void native_clearGatt(long var1);
    }
}

