/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.fota;

import com.polestar.naosdk.fota.BLESettings;
import com.polestar.naosdk.fota.Beacon;
import com.polestar.naosdk.fota.BeaconConfiguration;
import com.polestar.naosdk.fota.BeaconState;
import com.polestar.naosdk.fota.IBeaconConfListener;
import com.polestar.naosdk.fota.MissionState;
import com.polestar.naosdk.gatt.GattInterface;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class IBeaconConfService {
    public abstract void setCloudToken(String var1);

    public abstract void setSiteID(int var1);

    public abstract void downloadMissions();

    public abstract void startMission(int var1, boolean var2);

    public abstract void stopMission();

    public abstract void sendMissionsReports();

    public abstract ArrayList<Beacon> getBeaconsFromMission(int var1);

    public abstract BeaconConfiguration getBeaconConfToSynchronize(int var1, int var2);

    public abstract void setGattInterface(GattInterface var1);

    public abstract void setBeaconConfListener(IBeaconConfListener var1);

    public abstract MissionState getMissionState(int var1);

    public abstract BeaconState getBeaconState(int var1, int var2);

    public abstract void setBLESettings(BLESettings var1);

    public abstract BLESettings getBLESettings();

    public abstract void synchronizeBeaconWithConf(Beacon var1, BeaconConfiguration var2, BLESettings var3);

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class CppProxy
    extends IBeaconConfService {
        private final long nativeRef;
        private final AtomicBoolean a = new AtomicBoolean(false);

        private CppProxy(long l2) {
            if (l2 == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = l2;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean bl = this.a.getAndSet(true);
            if (!bl) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void setCloudToken(String string2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setCloudToken(this.nativeRef, string2);
        }

        private native void native_setCloudToken(long var1, String var3);

        @Override
        public void setSiteID(int n2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setSiteID(this.nativeRef, n2);
        }

        private native void native_setSiteID(long var1, int var3);

        @Override
        public void downloadMissions() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_downloadMissions(this.nativeRef);
        }

        private native void native_downloadMissions(long var1);

        @Override
        public void startMission(int n2, boolean bl) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_startMission(this.nativeRef, n2, bl);
        }

        private native void native_startMission(long var1, int var3, boolean var4);

        @Override
        public void stopMission() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_stopMission(this.nativeRef);
        }

        private native void native_stopMission(long var1);

        @Override
        public void sendMissionsReports() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_sendMissionsReports(this.nativeRef);
        }

        private native void native_sendMissionsReports(long var1);

        @Override
        public ArrayList<Beacon> getBeaconsFromMission(int n2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getBeaconsFromMission(this.nativeRef, n2);
        }

        private native ArrayList<Beacon> native_getBeaconsFromMission(long var1, int var3);

        @Override
        public BeaconConfiguration getBeaconConfToSynchronize(int n2, int n3) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getBeaconConfToSynchronize(this.nativeRef, n2, n3);
        }

        private native BeaconConfiguration native_getBeaconConfToSynchronize(long var1, int var3, int var4);

        @Override
        public void setGattInterface(GattInterface gattInterface) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setGattInterface(this.nativeRef, gattInterface);
        }

        private native void native_setGattInterface(long var1, GattInterface var3);

        @Override
        public void setBeaconConfListener(IBeaconConfListener iBeaconConfListener) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setBeaconConfListener(this.nativeRef, iBeaconConfListener);
        }

        private native void native_setBeaconConfListener(long var1, IBeaconConfListener var3);

        @Override
        public MissionState getMissionState(int n2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getMissionState(this.nativeRef, n2);
        }

        private native MissionState native_getMissionState(long var1, int var3);

        @Override
        public BeaconState getBeaconState(int n2, int n3) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getBeaconState(this.nativeRef, n2, n3);
        }

        private native BeaconState native_getBeaconState(long var1, int var3, int var4);

        @Override
        public void setBLESettings(BLESettings bLESettings) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setBLESettings(this.nativeRef, bLESettings);
        }

        private native void native_setBLESettings(long var1, BLESettings var3);

        @Override
        public BLESettings getBLESettings() {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getBLESettings(this.nativeRef);
        }

        private native BLESettings native_getBLESettings(long var1);

        @Override
        public void synchronizeBeaconWithConf(Beacon beacon, BeaconConfiguration beaconConfiguration, BLESettings bLESettings) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_synchronizeBeaconWithConf(this.nativeRef, beacon, beaconConfiguration, bLESettings);
        }

        private native void native_synchronizeBeaconWithConf(long var1, Beacon var3, BeaconConfiguration var4, BLESettings var5);
    }
}

