/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.controllers;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.app.JobIntentService;
import com.polestar.helpers.Log;
import com.polestar.helpers.PrefHelper;
import com.polestar.helpers.i;
import com.polestar.naosdk.api.IOSLocationRequestListener;
import com.polestar.naosdk.api.LocationFix;
import com.polestar.naosdk.api.external.NAOWakeUpNotifier;
import com.polestar.naosdk.controllers.AndroidCoverageService;
import com.polestar.naosdk.controllers.a;
import com.polestar.naosdk.controllers.b;
import com.polestar.naosdk.controllers.c;
import com.polestar.naosdk.managers.NaoServiceManager;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AndroidGeofencingJobService
extends JobIntentService {
    private String a;
    private Context a = ((Object)((Object)this)).getClass().getSimpleName();

    public static boolean a(Context context) {
        Log.restricted("AndroidGeofencingJobService", ">> isInsideOSGeofence: " + PrefHelper.get(context, "inside_geofence_area", false));
        return PrefHelper.get(context, "inside_geofence_area", false);
    }

    protected void onHandleWork(@NonNull Intent intent) {
        String string2;
        this.a = this.getApplicationContext();
        if (intent.hasExtra("event") && (string2 = intent.getStringExtra("event")) != null) {
            ArrayList arrayList = intent.getStringArrayListExtra("geofences");
            if (string2.equalsIgnoreCase("enter")) {
                this.a(arrayList);
            } else if (string2.equalsIgnoreCase("exit")) {
                this.b(arrayList);
            }
        }
    }

    @TargetApi(value=26)
    protected void a(ArrayList<String> arrayList) {
        Object object;
        boolean bl = AndroidGeofencingJobService.a(this.a);
        Log.restricted(this.a, " >> handleEnterSiteGeofences, geofences: " + arrayList + " isInsideOSGeofence: " + bl);
        if (!bl) {
            PrefHelper.put(this.a, "inside_geofence_area", true);
            object = com.polestar.naosdk.controllers.a.a(this.a);
            if (object != null) {
                String string2 = arrayList.get(0);
                ((NAOWakeUpNotifier)object).onEnterGPSArea();
                if (Build.VERSION.SDK_INT < 26) {
                    b b2 = new b(this.a);
                    int n2 = b2.a(string2);
                    Intent intent = new Intent(this.getApplicationContext(), AndroidCoverageService.class);
                    intent.putExtra("extra_timeout", n2 != -1 ? n2 : 3600000);
                    this.getApplicationContext().startService(intent);
                }
            }
        }
        if (Build.VERSION.SDK_INT >= 26 && ((a)(object = new a(this.a))).b()) {
            ((a)object).a((com.polestar.models.a)null);
        }
        this.stopSelf();
    }

    @TargetApi(value=26)
    protected void b(ArrayList<String> arrayList) {
        boolean bl = AndroidGeofencingJobService.a(this.a);
        Log.writeToLog(this.a, " >> handleExitSiteGeofences, geofences: " + arrayList + " isInsideOSGeofence: " + bl);
        if (arrayList.contains("sites_metacircle") || arrayList.contains("pdbs_metacircle")) {
            this.a(arrayList.toArray(new String[arrayList.size()]));
            arrayList.remove("sites_metacircle");
            arrayList.remove("pdbs_metacircle");
            if (arrayList.isEmpty()) {
                this.stopSelf();
                return;
            }
        }
        if (bl) {
            PrefHelper.put(this.a, "inside_geofence_area", false);
            NAOWakeUpNotifier nAOWakeUpNotifier = com.polestar.naosdk.controllers.a.a(this.a);
            if (nAOWakeUpNotifier != null) {
                nAOWakeUpNotifier.onExitGPSArea();
                if (Build.VERSION.SDK_INT < 26) {
                    if (AndroidCoverageService.a()) {
                        com.polestar.naosdk.controllers.a.a(this.getApplicationContext(), true);
                    } else {
                        Intent intent = new Intent(this.getApplicationContext(), AndroidCoverageService.class);
                        this.getApplicationContext().stopService(intent);
                    }
                }
            }
        }
        this.stopSelf();
    }

    protected void a(final String[] stringArray) {
        final Context context = this.a;
        if (NaoServiceManager.getService() == null) {
            this.a();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                c c2 = new c(context);
                c2.requestLocation(new IOSLocationRequestListener(){

                    @Override
                    public void onLocationResponse(LocationFix locationFix, String string2) {
                        try {
                            if (i.a()) {
                                if (Arrays.asList(stringArray).contains("sites_metacircle")) {
                                    Log.writeToLog(AndroidGeofencingJobService.this.a, "handleExitGeofences >> SITES_METACIRCLE_ID");
                                    NaoServiceManager.getService().getNaoContext().a.getGeofencingOSManager().onLocationResponse(locationFix, PrefHelper.get(context, "[logger]logs_app_key", null));
                                }
                                if (Arrays.asList(stringArray).contains("pdbs_metacircle") && PrefHelper.get(context, "auto_pdbs_synchro", PrefHelper.get(context, "[logger]logs_app_key", null), false)) {
                                    Log.writeToLog(AndroidGeofencingJobService.this.a, "handleExitGeofences >> PDBS_METACIRCLE_ID");
                                    NaoServiceManager.getService().getNaoContext().a.getPdbsManager().onLocationResponse(locationFix, PrefHelper.get(context, "[logger]logs_app_key", null));
                                }
                            } else {
                                Log.alwaysError(AndroidGeofencingJobService.this.a, "handleExitGeofences >> NAOERRORCODE.GENERIC_ERROR, Can't instantiate NaoContext");
                            }
                        }
                        catch (Exception exception) {
                            Log.alwaysError(AndroidGeofencingJobService.this.a, "handleExitGeofences >> Exception :" + exception);
                        }
                    }
                });
            }
        }).start();
    }

    private void a() {
        String string2 = PrefHelper.get(this.getApplicationContext(), "[logger]service_name", null);
        Log.restricted(this.a, " >> createNaoContext ");
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                NaoServiceManager.startService((Context)this, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
        }
    }

    public void onTaskRemoved(Intent intent) {
        Log.restricted(this.a, " >> onTaskRemoved");
        super.onTaskRemoved(intent);
    }

    public boolean onStopCurrentWork() {
        Log.restricted(this.a, " >> onStopCurrentWork");
        return false;
    }

    public void onDestroy() {
        super.onDestroy();
        Log.restricted(this.a, " >> onDestroy");
    }
}

