/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.controllers;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import com.polestar.helpers.Log;
import com.polestar.helpers.PrefHelper;
import com.polestar.helpers.i;
import com.polestar.models.RegisterBackgroundScanReceiver;
import com.polestar.naosdk.api.INAOCoverageClient;
import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.api.external.NAOWakeUpNotifier;
import com.polestar.naosdk.api.external.TPOWERMODE;
import com.polestar.naosdk.controllers.AndroidGeofencingService;
import com.polestar.naosdk.controllers.a;
import com.polestar.naosdk.managers.NaoServiceManager;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class AndroidCoverageService
extends Service
implements NAOSensorsListener {
    private String a;
    private static INAOCoverageClient a;
    private static ExecutorService a;
    private static String b;
    private boolean a;
    private boolean b = false;
    private int a;
    private Handler a;
    private Runnable a;
    private Context a;
    private Notification a;
    private com.polestar.naosdk.managers.a a;
    private RegisterBackgroundScanReceiver a = false;

    public static boolean a() {
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            boolean bl = NaoServiceManager.getService().getNaoContext().a.hasTriggeredEnterCoverage() || NaoServiceManager.getService().getNaoContext().a.hasTriggeredEnterSite();
            Log.restricted("AndroidCoverageService", ">> hasTriggeredEnterCoverage : " + bl);
            return bl;
        }
        Log.restricted("AndroidCoverageService", ">> hasTriggeredEnterCoverage: false");
        return false;
    }

    public void onCreate() {
        NAOWakeUpNotifier nAOWakeUpNotifier;
        super.onCreate();
        if (Build.VERSION.SDK_INT >= 26 && (nAOWakeUpNotifier = com.polestar.naosdk.controllers.a.a(this.getApplicationContext())) != null) {
            this.a = nAOWakeUpNotifier.wakeUpNotification();
            if (this.a != null) {
                this.startForeground(1000, this.a);
            } else {
                com.polestar.helpers.a.a.a((Context)this, "my_service", "My Background Service");
                NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, "my_service");
                Notification notification = builder.build();
                this.startForeground(1000, notification);
            }
        }
    }

    public int onStartCommand(Intent intent, int n2, int n3) {
        this.a = this.getBaseContext();
        if (Build.VERSION.SDK_INT >= 26 && this.a == null) {
            this.a = new RegisterBackgroundScanReceiver();
            this.registerReceiver(this.a, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
        }
        if (a == null) {
            a = Executors.newSingleThreadExecutor();
        }
        if (a == null) {
            a = new INAOCoverageClient(){

                @Override
                @TargetApi(value=26)
                public void onBeaconCoverageEnter(String string2) {
                    Object object;
                    Log.restricted(AndroidCoverageService.this.a, ">> onBeaconCoverageEnter: " + string2);
                    if (com.polestar.naosdk.controllers.a.a() != null) {
                        object = com.polestar.naosdk.controllers.a.a().iterator();
                        while (object.hasNext()) {
                            WeakReference weakReference = (WeakReference)object.next();
                            ((com.polestar.models.a)weakReference.get()).c();
                        }
                    }
                    if ((object = com.polestar.naosdk.controllers.a.a(AndroidCoverageService.this.a)) != null && b != "action_check_exit") {
                        AndroidCoverageService.this.a = true;
                        ((NAOWakeUpNotifier)object).onEnterBeaconArea();
                    }
                    if (b != "action_check_exit") {
                        AndroidCoverageService.this.b();
                    }
                }

                @Override
                @TargetApi(value=26)
                public void onBeaconCoverageExit() {
                    Log.restricted(AndroidCoverageService.this.a, ">> onBeaconCoverageExit");
                    if (Build.VERSION.SDK_INT < 26 && b == "action_check_exit" || Build.VERSION.SDK_INT >= 26) {
                        AndroidCoverageService.this.a(AndroidCoverageService.this.a);
                    }
                }

                @Override
                public void onError(NAOERRORCODE nAOERRORCODE, String string2) {
                    Log.alwaysError(AndroidCoverageService.this.a, "Error: " + (Object)((Object)nAOERRORCODE) + " " + string2);
                }

                @Override
                public void setEnterEventTimeout(int n2) {
                    Log.restricted(AndroidCoverageService.this.a, ">> setEnterEventTimeout");
                    if (b != "action_check_exit") {
                        AndroidCoverageService.this.b();
                    }
                }
            };
        }
        if (this.a == null) {
            this.a = new Handler(this.a.getApplicationContext().getMainLooper());
        }
        if (Build.VERSION.SDK_INT < 26) {
            this.a = intent.getIntExtra("extra_timeout", 3600000);
        }
        b = intent.getAction() != null ? intent.getAction() : "action_check_enter";
        Log.restricted(this.a, ">> mLastAction: " + b);
        this.c();
        if (b == "action_check_exit") {
            this.d();
        }
        return 2;
    }

    private void c() {
        String string2 = PrefHelper.get(this.getApplicationContext(), "[logger]service_name", null);
        Log.restricted(this.a, "startCoverageHandle >> " + string2 + " - coverageServiceRunning: " + this.b);
        if (string2 != null && !this.b) {
            try {
                Class<?> clazz = Class.forName(string2);
                if (NaoServiceManager.getService() == null) {
                    NaoServiceManager.startService(this.a, clazz);
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (i.a()) {
                            if (AndroidCoverageService.this.a == null) {
                                AndroidCoverageService.this.a = new com.polestar.naosdk.managers.a(AndroidCoverageService.this.a, AndroidCoverageService.this, new ContextWrapper(AndroidCoverageService.this.a));
                            }
                            a.execute(new Runnable(){

                                @Override
                                public void run() {
                                    if (NaoServiceManager.getService().getNaoContext().a.registerCoverageClient(a, PrefHelper.get(AndroidCoverageService.this.getApplicationContext(), "[logger]logs_app_key", null), AndroidCoverageService.this.a)) {
                                        AndroidCoverageService.this.b = true;
                                        if (Build.VERSION.SDK_INT < 26) {
                                            AndroidCoverageService.this.e();
                                        }
                                    }
                                    NaoServiceManager.getService().getNaoContext().a.setCoverageClientPowerMode(TPOWERMODE.LOW, a);
                                }
                            });
                        }
                    }
                }).start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void a() {
        if (a != null) {
            a.execute(new Runnable(){

                @Override
                public void run() {
                    if (i.a()) {
                        Log.alwaysWarn(AndroidCoverageService.this.a, ">> unregisterCoverageClient");
                        NaoServiceManager.getService().getNaoContext().a.unregisterCoverageClient(a);
                        a = null;
                        AndroidCoverageService.this.b = false;
                    } else {
                        Log.alwaysWarn(AndroidCoverageService.this.a, "Can't instantiate NaoContext");
                    }
                }
            });
        } else {
            Log.alwaysWarn(this.a, "Cannot stop coverage client because not instantiated");
        }
    }

    public void a(Context context) {
        Object object;
        Log.writeToLog(this.a, "triggExitCoverageRegion >> onBeaconCoverageExit");
        if (com.polestar.naosdk.controllers.a.a() != null) {
            object = com.polestar.naosdk.controllers.a.a().iterator();
            while (object.hasNext()) {
                WeakReference weakReference = (WeakReference)object.next();
                ((com.polestar.models.a)weakReference.get()).d();
            }
        }
        if ((object = com.polestar.naosdk.controllers.a.a(context)) != null && this.a) {
            this.a = false;
            ((NAOWakeUpNotifier)object).onExitBeaconArea();
            if (Build.VERSION.SDK_INT < 26 && !AndroidGeofencingService.isInsideOSGeofence(context) || Build.VERSION.SDK_INT >= 26 && !com.polestar.naosdk.controllers.a.a(context)) {
                ((NAOWakeUpNotifier)object).onExitCoverage();
            }
        }
        this.b();
    }

    private void d() {
        Log.restricted(this.a, "checkExitCoverage >> wait for exit site");
        new Thread(new Runnable(){

            @Override
            public void run() {
                AndroidCoverageService.this.a = true;
                while (Build.VERSION.SDK_INT < 26 && !AndroidGeofencingService.isInsideOSGeofence(AndroidCoverageService.this.a) || Build.VERSION.SDK_INT >= 26 && !com.polestar.naosdk.controllers.a.a(AndroidCoverageService.this.a)) {
                    if (!AndroidCoverageService.a()) {
                        Log.restricted(AndroidCoverageService.this.a, "checkExitCoverage >> onExitCoverage");
                        AndroidCoverageService.this.a(AndroidCoverageService.this.a);
                        AndroidCoverageService.this.b();
                        break;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                if (Build.VERSION.SDK_INT < 26 && AndroidGeofencingService.isInsideOSGeofence(AndroidCoverageService.this.a) || Build.VERSION.SDK_INT >= 26 && com.polestar.naosdk.controllers.a.a(AndroidCoverageService.this.a)) {
                    Log.writeToLog(AndroidCoverageService.this.a, ">> isInsideOSGeofence now");
                    AndroidCoverageService.this.b();
                }
            }
        }).start();
    }

    private void e() {
        Log.writeToLog(this.a, ">> startTimeOutCheck with timeout: " + this.a);
        this.a = new Runnable(){

            @Override
            public void run() {
                if (AndroidCoverageService.this.b && !AndroidCoverageService.a()) {
                    AndroidCoverageService.this.b();
                }
            }
        };
        this.a.postDelayed(this.a, (long)this.a);
    }

    private void f() {
        this.a.removeCallbacks(this.a);
    }

    public void b() {
        Log.restricted(this.a, " >> stopCurrentService");
        this.a.postDelayed(new Runnable(){

            @Override
            public void run() {
                AndroidCoverageService.this.stopSelf();
            }
        }, 1000L);
    }

    public void onTaskRemoved(Intent intent) {
        Log.restricted(this.a, ">> onTaskRemoved");
        super.onTaskRemoved(intent);
    }

    public void onDestroy() {
        Log.restricted(this.a, ">> onDestroy");
        if (Build.VERSION.SDK_INT < 26) {
            this.f();
        }
        if (this.b) {
            this.a();
        }
        if (this.a != null) {
            this.unregisterReceiver(this.a);
        }
        super.onDestroy();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void requiresCompassCalibration() {
        Log.restricted(this.a, "Require compas");
    }

    @Override
    public void requiresWifiOn() {
        Log.restricted(this.a, "Require Wifi");
    }

    @Override
    public void requiresBLEOn() {
        Log.restricted(this.a, "Require BLE");
    }

    @Override
    public void requiresLocationOn() {
        Log.restricted(this.a, "Require location");
    }
}

