/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api.external;

import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import com.polestar.helpers.Log;
import com.polestar.helpers.PrefHelper;
import com.polestar.helpers.i;
import com.polestar.naosdk.api.ICallback;
import com.polestar.naosdk.api.TSENSORTYPE;
import com.polestar.naosdk.api.external.NAOException;
import com.polestar.naosdk.api.external.NAOWakeUpNotifier;
import com.polestar.naosdk.api.external.NAOWakeUpRegistrationListener;
import com.polestar.naosdk.api.external.TPOWERMODE;
import com.polestar.naosdk.controllers.a;
import com.polestar.naosdk.controllers.b;
import com.polestar.naosdk.managers.NaoContext;
import com.polestar.naosdk.managers.NaoServiceManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class NAOServicesConfig {
    private static ExecutorService a = Executors.newSingleThreadExecutor();
    public static final String[] BASIC_PERMISSIONS = new String[]{"android.permission.ACCESS_FINE_LOCATION"};

    public static void setRootURL(String string2) {
        NaoContext.a = string2;
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            NaoServiceManager.getService().getNaoContext().setRootURL(string2);
        }
    }

    public static void setProxy(String string2, int n2, String string3, String string4) {
        NaoContext.a = new NaoContext.a(string2, n2, string3, string4);
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            NaoServiceManager.getService().getNaoContext().setProxy(string2, n2, string3, string4);
        }
    }

    public static String getRootURL() {
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            return NaoServiceManager.getService().getNaoContext().a.getRootURL();
        }
        return NaoContext.getRootURL();
    }

    public static TPOWERMODE getPowerMode() {
        if (NaoServiceManager.getService() == null || NaoServiceManager.getService().getNaoContext() == null) {
            return TPOWERMODE.LOW;
        }
        return NaoServiceManager.getService().getNaoContext().getPowerMode();
    }

    public static String getSoftwareVersion() {
        return NaoContext.getSoftwareVersion();
    }

    public static void enableOnSiteWakeUp(@NonNull Context context, @NonNull String string2, @NonNull Class<? extends NAOWakeUpNotifier> clazz, NAOWakeUpRegistrationListener nAOWakeUpRegistrationListener) {
        PrefHelper.put(context, "[logger]wake_up_notifier", clazz.getName());
        if (Build.VERSION.SDK_INT < 26) {
            b b2 = new b(context);
            b2.a(nAOWakeUpRegistrationListener);
            b2.a(string2);
        } else {
            a a2 = new a(context);
            a2.a(string2, nAOWakeUpRegistrationListener);
        }
    }

    @RequiresApi(api=26)
    public static void disableOnSiteWakeUp(@NonNull Context context, @NonNull String string2, NAOWakeUpRegistrationListener nAOWakeUpRegistrationListener) {
        PrefHelper.put(context, "[logger]wake_up_notifier", null);
        PrefHelper.put(context, "inside_geofence_area", false);
        a a2 = new a(context);
        a2.a();
        b b2 = new b(context);
        b2.a(nAOWakeUpRegistrationListener);
        b2.a();
    }

    public static boolean isWakeUpNotifierRegistered(Context context) {
        return null != PrefHelper.get(context, "[logger]wake_up_notifier", null);
    }

    public static void uploadNAOLogInfo(String string2) throws NAOException {
        if (string2 == null) {
            string2 = new String("");
        }
        NAOServicesConfig.getNaoContextOrThrow().a.uploadNAOLogInfo(string2);
    }

    public static void uploadNAOLogInfo(Context context, final String string2, String string3, final ICallback iCallback) {
        if (PrefHelper.get(context.getApplicationContext(), "[logger]logs_app_key", null) == null) {
            iCallback.onFailure("NaoContext instance is not initialized");
            return;
        }
        if (string3 == null) {
            string3 = new String("");
        }
        final String string4 = string3;
        if (NaoServiceManager.getService() != null && NaoServiceManager.getService().getNaoContext() != null) {
            NaoServiceManager.getService().getNaoContext().a.uploadNAOLogDirectory(string2, string3, iCallback);
        } else {
            try {
                NAOServicesConfig.a(context);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        if (i.a()) {
                            a.execute(new Runnable(){

                                @Override
                                public void run() {
                                    NaoServiceManager.getService().getNaoContext().a.uploadNAOLogDirectory(string2, string4, iCallback);
                                }
                            });
                        } else {
                            iCallback.onFailure("Cannot create NaoContext");
                        }
                    }
                }).start();
            }
            catch (NAOException nAOException) {
                iCallback.onFailure("UploadNAOLogInfo failed: cannot create NaoContext instance");
                nAOException.printStackTrace();
            }
        }
    }

    public static void startLoggingMeasurements() throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.getMeasureLogger().startLoggingMeasurements("", true);
    }

    public static void stopLoggingMeasurements() throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.getMeasureLogger().stopLoggingMeasurements();
    }

    public static void setSensorBypass(String string2, boolean bl) throws NAOException {
        NAOServicesConfig.getNaoContextOrThrow().a.setSensorBypass(TSENSORTYPE.valueOf(string2), bl);
    }

    public static NaoContext getNaoContextOrThrow() throws NAOException {
        if (NaoServiceManager.getService() == null || NaoServiceManager.getService().getNaoContext() == null) {
            throw new NAOException("No NaoContext instance: you must first instantiate a service handle.");
        }
        return NaoServiceManager.getService().getNaoContext();
    }

    private static void a(Context context) throws NAOException {
        String string2 = PrefHelper.get(context, "[logger]service_name", null);
        Log.restricted("NAOServicesConfig", "createNaoServiceManager >> " + string2);
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                if (NaoServiceManager.getService() == null) {
                    NaoServiceManager.startService(context, clazz);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            throw new NAOException("NaoContext instance has not been initialized");
        }
    }
}

