/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api;

import android.content.Context;
import android.content.ContextWrapper;
import android.location.Location;
import android.os.Handler;
import android.support.annotation.NonNull;
import com.polestar.b.a;
import com.polestar.helpers.AssetCopier;
import com.polestar.helpers.Log;
import com.polestar.helpers.h;
import com.polestar.models.j;
import com.polestar.naosdk.a.b;
import com.polestar.naosdk.api.INAOServiceManager;
import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOErrorListener;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.api.external.NAOSyncListener;
import com.polestar.naosdk.api.external.TPOWERMODE;
import com.polestar.naosdk.managers.NaoServiceManager;
import java.io.File;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class INAOServiceProvider<ExternalListener extends NAOErrorListener, InternalServiceClient> {
    final Handler mainHandler;
    protected final ContextWrapper myContext;
    protected final h mPathHelper;
    protected final String myApiKey;
    protected final ExternalListener myExternalListener;
    protected final com.polestar.naosdk.managers.a myISensorRequestListener;
    private b a;
    protected InternalServiceClient a;
    protected TPOWERMODE a;
    protected Location a = TPOWERMODE.HIGH;

    public INAOServiceProvider(Context context, Class<?> clazz, @NonNull String string2, @NonNull ExternalListener ExternalListener, @NonNull NAOSensorsListener nAOSensorsListener) {
        this.myApiKey = string2;
        this.myExternalListener = ExternalListener;
        this.myContext = new ContextWrapper(context);
        this.mainHandler = new Handler(this.myContext.getApplicationContext().getMainLooper());
        this.myISensorRequestListener = new com.polestar.naosdk.managers.a(this.mainHandler, nAOSensorsListener, this.myContext);
        this.mPathHelper = new h(context);
        NaoServiceManager.startService(context, clazz);
        if (this.myApiKey.equalsIgnoreCase("emulator")) {
            Log.alwaysWarn(this.getClass().getName(), "Using EMULATOR_KEY");
        }
        this.a = this.a();
    }

    protected INAOServiceManager a() {
        return NaoServiceManager.getService().getNaoContext().a;
    }

    public Context getApplicationContext() {
        return this.myContext.getApplicationContext();
    }

    protected abstract InternalServiceClient a();

    protected b a() {
        return null;
    }

    void a() {
        AssetCopier assetCopier = new AssetCopier(this.myContext);
        File file = new File(this.a().getRootDir() + File.separator + "app.json");
        if (!assetCopier.copyAssetFile(file.getName(), file.getParent())) {
            return;
        }
        String string2 = this.a().getAppLocalDir(this.myApiKey);
        String string3 = this.a().getAppFilePath(this.myApiKey);
        boolean bl = INAOServiceManager.needsToCopyAssets(string3, file.getAbsolutePath());
        assetCopier.copyAssetDirectory("pdbs", string2, bl);
        File file2 = new File(string3);
        if (bl || !file2.exists()) {
            assetCopier.copyAssetFile(file2.getName(), string2);
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract boolean a();

    protected abstract void b();

    protected void a(Runnable runnable) {
        this.mainHandler.post(runnable);
    }

    public boolean start() {
        this.a();
        if (this.myApiKey.equalsIgnoreCase("emulator")) {
            if (this.a == null) {
                this.a = this.a();
                if (this.a == null) {
                    return false;
                }
                AssetCopier assetCopier = new AssetCopier(this.myContext);
                assetCopier.copyAssetFile(this.a.a(), this.mPathHelper.a());
            }
            this.a.b();
            return true;
        }
        boolean bl = this.a();
        this.setPowerMode(this.a);
        return bl;
    }

    public final void stop() {
        if (this.a != null) {
            this.a.a();
        } else {
            this.b();
        }
    }

    public void synchronizeData(NAOSyncListener nAOSyncListener) {
        a a2 = new a(this.myContext, this.myApiKey, nAOSyncListener);
        if (!this.myApiKey.equalsIgnoreCase("emulator")) {
            this.a().synchronizeData(this.myApiKey, a2);
        } else {
            a2.onSyncSuccess();
            Log.alwaysWarn(this.getClass().getName(), "onSynchronizationSuccess...");
        }
    }

    public void synchronizeData(NAOSyncListener nAOSyncListener, ArrayList<String> arrayList) {
        a a2 = new a(this.myContext, this.myApiKey, nAOSyncListener);
        if (!this.myApiKey.equalsIgnoreCase("emulator")) {
            this.a().synchronizeDataForSites(this.myApiKey, a2, arrayList);
        } else {
            a2.onSyncSuccess();
            Log.alwaysWarn(this.getClass().getName(), "onSynchronizationSuccess...");
        }
    }

    public void synchronizeData(NAOSyncListener nAOSyncListener, Boolean bl) {
        a a2 = new a(this.myContext, this.myApiKey, nAOSyncListener);
        if (!this.myApiKey.equalsIgnoreCase("emulator")) {
            this.a().synchronizeMultiSitesData(this.myApiKey, a2, bl);
        } else {
            a2.onSyncSuccess();
            Log.alwaysWarn(this.getClass().getName(), "onSynchronizationSuccess...");
        }
    }

    public TPOWERMODE getPowerMode() {
        return this.a;
    }

    public void setPowerMode(@NonNull TPOWERMODE tPOWERMODE) {
        this.a = tPOWERMODE;
        this.a(tPOWERMODE);
        Log.restricted(this.getClass().getName(), "Set Power Mode to " + this.a.name());
    }

    protected abstract void a(TPOWERMODE var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalLocation(@NonNull Location location) {
        Log.restricted(this.getClass().getName(), "setExternalLocation");
        location.setProvider(j.a);
        if (this.a == null) {
            this.a = new Location(location);
        }
        Location location2 = this.a;
        synchronized (location2) {
            this.a.set(location);
            if (this.a().hasServiceClients("")) {
                this.a(this.a);
            }
        }
    }

    protected abstract void a(Location var1);

    public String getApiKey() {
        return this.myApiKey;
    }

    public void notifyError(NAOERRORCODE nAOERRORCODE, String string2) {
        if (this.myExternalListener != null) {
            this.myExternalListener.onError(nAOERRORCODE, string2);
        }
    }
}

