/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api;

import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NaoAlert;
import com.polestar.naosdk.api.external.TALERTRULE;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class INAOGeofencingClient {
    public abstract void onFireNaoAlert(NaoAlert var1, TALERTRULE var2);

    public abstract void onGeofenceStatusChange(TALERTRULE var1, int var2, String var3);

    public abstract void onError(NAOERRORCODE var1, String var2);

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class CppProxy
    extends INAOGeofencingClient {
        private final long nativeRef;
        private final AtomicBoolean a = new AtomicBoolean(false);

        private CppProxy(long l2) {
            if (l2 == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = l2;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean bl = this.a.getAndSet(true);
            if (!bl) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void onFireNaoAlert(NaoAlert naoAlert, TALERTRULE tALERTRULE) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onFireNaoAlert(this.nativeRef, naoAlert, tALERTRULE);
        }

        private native void native_onFireNaoAlert(long var1, NaoAlert var3, TALERTRULE var4);

        @Override
        public void onGeofenceStatusChange(TALERTRULE tALERTRULE, int n2, String string2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onGeofenceStatusChange(this.nativeRef, tALERTRULE, n2, string2);
        }

        private native void native_onGeofenceStatusChange(long var1, TALERTRULE var3, int var4, String var5);

        @Override
        public void onError(NAOERRORCODE nAOERRORCODE, String string2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_onError(this.nativeRef, nAOERRORCODE, string2);
        }

        private native void native_onError(long var1, NAOERRORCODE var3, String var4);
    }
}

