/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class IHttpHelper {
    public abstract int sendFile(String var1, String var2);

    public abstract int getFile(String var1, String var2);

    public abstract int getFileIfModified(String var1, String var2, String var3);

    public abstract String getText(String var1);

    public abstract String postText(String var1, HashMap<String, String> var2);

    public abstract boolean zipAndUploadFiles(ArrayList<String> var1, String var2, String var3, String var4, ArrayList<String> var5);

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class CppProxy
    extends IHttpHelper {
        private final long nativeRef;
        private final AtomicBoolean a = new AtomicBoolean(false);

        private CppProxy(long l2) {
            if (l2 == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = l2;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean bl = this.a.getAndSet(true);
            if (!bl) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public int sendFile(String string2, String string3) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_sendFile(this.nativeRef, string2, string3);
        }

        private native int native_sendFile(long var1, String var3, String var4);

        @Override
        public int getFile(String string2, String string3) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getFile(this.nativeRef, string2, string3);
        }

        private native int native_getFile(long var1, String var3, String var4);

        @Override
        public int getFileIfModified(String string2, String string3, String string4) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getFileIfModified(this.nativeRef, string2, string3, string4);
        }

        private native int native_getFileIfModified(long var1, String var3, String var4, String var5);

        @Override
        public String getText(String string2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_getText(this.nativeRef, string2);
        }

        private native String native_getText(long var1, String var3);

        @Override
        public String postText(String string2, HashMap<String, String> hashMap) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_postText(this.nativeRef, string2, hashMap);
        }

        private native String native_postText(long var1, String var3, HashMap<String, String> var4);

        @Override
        public boolean zipAndUploadFiles(ArrayList<String> arrayList, String string2, String string3, String string4, ArrayList<String> arrayList2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            return this.native_zipAndUploadFiles(this.nativeRef, arrayList, string2, string3, string4, arrayList2);
        }

        private native boolean native_zipAndUploadFiles(long var1, ArrayList<String> var3, String var4, String var5, String var6, ArrayList<String> var7);
    }
}

