/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.naosdk.api;

import java.util.concurrent.atomic.AtomicBoolean;

public abstract class ICrashLogHelper {
    public abstract void log(String var1);

    public abstract void setString(String var1, String var2);

    public abstract void setInt(String var1, int var2);

    public abstract void setFloat(String var1, float var2);

    public abstract void setBool(String var1, boolean var2);

    public abstract void setUserIdentifier(String var1);

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    private static final class CppProxy
    extends ICrashLogHelper {
        private final long nativeRef;
        private final AtomicBoolean a = new AtomicBoolean(false);

        private CppProxy(long l2) {
            if (l2 == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = l2;
        }

        private native void nativeDestroy(long var1);

        public void destroy() {
            boolean bl = this.a.getAndSet(true);
            if (!bl) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        @Override
        public void log(String string2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_log(this.nativeRef, string2);
        }

        private native void native_log(long var1, String var3);

        @Override
        public void setString(String string2, String string3) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setString(this.nativeRef, string2, string3);
        }

        private native void native_setString(long var1, String var3, String var4);

        @Override
        public void setInt(String string2, int n2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setInt(this.nativeRef, string2, n2);
        }

        private native void native_setInt(long var1, String var3, int var4);

        @Override
        public void setFloat(String string2, float f2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setFloat(this.nativeRef, string2, f2);
        }

        private native void native_setFloat(long var1, String var3, float var4);

        @Override
        public void setBool(String string2, boolean bl) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setBool(this.nativeRef, string2, bl);
        }

        private native void native_setBool(long var1, String var3, boolean var4);

        @Override
        public void setUserIdentifier(String string2) {
            assert (!this.a.get()) : "trying to use a destroyed object";
            this.native_setUserIdentifier(this.nativeRef, string2);
        }

        private native void native_setUserIdentifier(long var1, String var3);
    }
}

