/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.models;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.polestar.helpers.Log;
import com.polestar.naosdk.controllers.AndroidGeofencingService;
import java.util.ArrayList;

public class GeofenceTransitionReceiver
extends BroadcastReceiver {
    private Context a;

    public void onReceive(Context context, Intent intent) {
        Log.writeToLog(((Object)((Object)this)).getClass().getName(), "GeofenceTransitionReceiver >> onReceive");
        this.a = context;
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent != null) {
            if (geofencingEvent.hasError()) {
                this.a(geofencingEvent.getErrorCode());
            } else {
                int n2 = geofencingEvent.getGeofenceTransition();
                if (n2 == 1 || n2 == 4 || n2 == 2) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i2 = 0; i2 < geofencingEvent.getTriggeringGeofences().size(); ++i2) {
                        arrayList.add(((Geofence)geofencingEvent.getTriggeringGeofences().get(i2)).getRequestId());
                    }
                    if (n2 == 1 || n2 == 4) {
                        arrayList.remove("sites_metacircle");
                        if (arrayList.isEmpty()) {
                            return;
                        }
                        this.a(arrayList);
                    } else if (n2 == 2) {
                        this.b(arrayList);
                    }
                } else {
                    Log.writeToLog(((Object)((Object)this)).getClass().getName(), "GeofenceTransitionReceiver >> onHandleIntent unsupported geofence type");
                }
            }
        } else {
            Log.writeToLog(((Object)((Object)this)).getClass().getName(), "GeofenceTransitionReceiver >> onHandleIntent without event");
        }
    }

    protected void a(ArrayList<String> arrayList) {
        Log.alwaysWarn(((Object)((Object)this)).getClass().getName(), "GeofenceTransitionReceiver >> onEnter");
        Intent intent = new Intent(this.a, AndroidGeofencingService.class);
        intent.putExtra("event", "enter");
        intent.putExtra("geofences", arrayList);
        if (Build.VERSION.SDK_INT < 26) {
            this.a.startService(intent);
        } else {
            this.a.startForegroundService(intent);
        }
    }

    protected void b(ArrayList<String> arrayList) {
        Log.alwaysWarn(((Object)((Object)this)).getClass().getName(), "GeofenceTransitionReceiver >> onExit");
        Intent intent = new Intent(this.a, AndroidGeofencingService.class);
        intent.putExtra("event", "exit");
        intent.putExtra("geofences", arrayList);
        if (Build.VERSION.SDK_INT < 26) {
            this.a.startService(intent);
        } else {
            this.a.startForegroundService(intent);
        }
    }

    protected void a(int n2) {
        Log.alwaysError(((Object)((Object)this)).getClass().getName(), "Error: " + n2);
    }
}

