/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.models;

import android.annotation.TargetApi;
import android.app.IntentService;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.GeofencingEvent;
import com.polestar.helpers.Log;
import com.polestar.naosdk.controllers.AndroidGeofencingService;
import java.util.ArrayList;

public class GeofenceTransition
extends IntentService {
    private Intent a;

    public GeofenceTransition() {
        super("ReceiveGeofenceTransitionIntentService");
    }

    protected void onHandleIntent(Intent intent) {
        Log.writeToLog(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onHandleIntent");
        GeofencingEvent geofencingEvent = GeofencingEvent.fromIntent((Intent)intent);
        if (geofencingEvent != null) {
            if (geofencingEvent.hasError()) {
                this.a(geofencingEvent.getErrorCode());
            } else {
                this.a = intent;
                int n2 = geofencingEvent.getGeofenceTransition();
                if (n2 == 1 || n2 == 4 || n2 == 2) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (int i2 = 0; i2 < geofencingEvent.getTriggeringGeofences().size(); ++i2) {
                        arrayList.add(((Geofence)geofencingEvent.getTriggeringGeofences().get(i2)).getRequestId());
                    }
                    if (n2 == 1 || n2 == 4) {
                        arrayList.remove("sites_metacircle");
                        if (arrayList.isEmpty()) {
                            return;
                        }
                        this.a(arrayList);
                    } else if (n2 == 2) {
                        this.b(arrayList);
                    }
                } else {
                    Log.writeToLog(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onHandleIntent unsupported geofence type");
                }
            }
        } else {
            Log.writeToLog(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onHandleIntent without event");
        }
    }

    protected void a(ArrayList<String> arrayList) {
        Log.alwaysWarn(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onEnter");
        Intent intent = new Intent((Context)this, AndroidGeofencingService.class);
        intent.putExtra("event", "enter");
        intent.putExtra("geofences", arrayList);
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForegroundService(intent);
        } else {
            this.startService(intent);
        }
    }

    protected void b(ArrayList<String> arrayList) {
        Log.alwaysWarn(((Object)((Object)this)).getClass().getName(), "GeofenceTransition >> onExit");
        Intent intent = new Intent((Context)this, AndroidGeofencingService.class);
        intent.putExtra("event", "exit");
        intent.putExtra("geofences", arrayList);
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForegroundService(intent);
        } else {
            this.startService(intent);
        }
    }

    public static Intent getGeofenceTransitionForwardIntent(Context context, Intent intent, int n2) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null) {
            throw new RuntimeException("Missing intent component");
        }
        Intent intent2 = new Intent(intent).putExtra("com.polestar.naosdk.controllers.AndroidGeofencingJobService", componentName.getClassName()).putExtra("extra_job_id", n2);
        intent2.setClass(context.getApplicationContext(), GeofenceTransition.class);
        return intent2;
    }

    @TargetApi(value=26)
    public static boolean isGeofencingJobServiceOn(Context context) {
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        boolean bl = false;
        for (JobInfo jobInfo : jobScheduler.getAllPendingJobs()) {
            if (jobInfo.getId() != 1000) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void a(int n2) {
        Log.alwaysError(((Object)((Object)this)).getClass().getName(), "Error: " + n2);
    }
}

