/*
 * Decompiled with CFR 0.152.
 */
package com.polestar.helpers;

import android.content.ContextWrapper;
import android.content.res.AssetManager;
import android.os.Environment;
import com.polestar.helpers.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AssetCopier {
    public static final String SDCARD_PATH = Environment.getExternalStorageDirectory().toString() + "/";
    private AssetManager a;

    public AssetCopier(ContextWrapper contextWrapper) {
        if (contextWrapper == null) {
            Log.alwaysError(this.getClass().getName(), "null reference in AssetCopier constructor");
            this.a = null;
            return;
        }
        this.a = contextWrapper.getAssets();
    }

    public static void createDirectory(String string) {
        Log.restricted("com.polestar.helpers.AssetCopier", "creating directory : " + string);
        try {
            new File(string).mkdirs();
        }
        catch (Exception exception) {
            Log.alwaysError("com.polestar.helpers.AssetCopier", "ERROR : " + exception.toString() + "\n");
        }
    }

    public void copyAssetFile(String string, String string2, String string3) {
        if (this.a == null) {
            return;
        }
        String string4 = string2.length() > 0 ? string2 + "/" + string : string;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[2000];
        try {
            inputStream = this.a.open(string4);
        }
        catch (IOException iOException) {
            Log.restricted(this.getClass().getName(), "ERROR in copyAssetFile(): " + iOException.toString());
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(string3 + "/" + string);
        }
        catch (Exception exception) {
            Log.restricted(this.getClass().getName(), "ERROR in copyAssetFile(): " + exception.toString());
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            Log.restricted(this.getClass().getName(), "ERROR in copyAssetFile(): " + iOException.toString());
        }
    }

    public boolean copyAssetFile(String string, String string2) {
        if (this.a == null) {
            return false;
        }
        String string3 = string;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[2000];
        try {
            inputStream = this.a.open(string3);
        }
        catch (IOException iOException) {
            Log.restricted(this.getClass().getName(), "ERROR in copyAssetFile(): " + iOException.toString());
            return false;
        }
        try {
            fileOutputStream = new FileOutputStream(string2 + "/" + string);
        }
        catch (Exception exception) {
            Log.restricted(this.getClass().getName(), "ERROR in copyAssetFile(): " + exception.toString());
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            Log.alwaysError(this.getClass().getName(), "ERROR in copyAssetFile(): " + iOException.toString());
            return false;
        }
        return true;
    }

    public boolean forceAssetsOverwrite() {
        InputStream inputStream = null;
        try {
            inputStream = this.a.open("force_asset_overwrite.json");
        }
        catch (IOException iOException) {
            Log.alwaysError(this.getClass().getName(), "ERROR in forceAssetsOverwrite(): " + iOException.toString());
            return false;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            Log.alwaysError(this.getClass().getName(), "ERROR in forceAssetsOverwrite(): " + iOException.toString());
        }
        return true;
    }

    public static void copyFile(String string, String string2) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        byte[] byArray = new byte[2000];
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            Log.alwaysError("com.polestar.helpers.AssetCopier", "ERROR in copyFile: " + iOException.toString());
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(string2);
        }
        catch (Exception exception) {
            Log.alwaysError("com.polestar.helpers.AssetCopier", "ERROR in copyFile: " + exception.toString());
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        try {
            int n2;
            while ((n2 = ((InputStream)fileInputStream).read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n2);
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            Log.alwaysError("com.polestar.helpers.AssetCopier", "ERROR in copyFile: " + iOException.toString());
        }
    }

    public void copyAssetDirectory(String string, String string2, boolean bl) {
        if (this.a == null) {
            return;
        }
        String string3 = string2 + "/" + string;
        AssetCopier.createDirectory(string3);
        String[] stringArray = null;
        try {
            stringArray = this.a.list(string);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                boolean bl2 = new File(string3, stringArray[i2]).exists();
                if (bl2 && !bl) continue;
                this.copyAssetFile(stringArray[i2], string, string3);
            }
        }
        catch (IOException iOException) {
            Log.alwaysError(this.getClass().getName(), "ERROR in copyAssetDirectory : " + iOException.toString());
        }
    }

    public void copyAssetAllDirectories(String string, String string2, boolean bl, int n2) {
        if (this.a == null) {
            return;
        }
        String[] stringArray = null;
        try {
            stringArray = this.a.list(string);
            if (stringArray.length == 0) {
                boolean bl2 = new File(string2, string).exists();
                if (!bl2 || bl) {
                    Log.alwaysWarn(this.getClass().getName(), "copyAssetFile : " + string);
                    this.copyAssetFile(string, string2);
                }
            } else {
                String string3 = string2 + "/" + string;
                AssetCopier.createDirectory(string3);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (stringArray[i2].equals("webkit") || stringArray[i2].equals("images") || stringArray[i2].equals("sounds") || stringArray[i2].contains(".jar")) continue;
                    Log.alwaysWarn(this.getClass().getName(), "copyAssetDirectory : " + string + "/" + stringArray[i2]);
                    if (n2 >= 1) {
                        this.copyAssetAllDirectories(string + "/" + stringArray[i2], string2, bl, n2 + 1);
                        continue;
                    }
                    this.copyAssetAllDirectories(stringArray[i2], string2, bl, n2 + 1);
                }
            }
        }
        catch (IOException iOException) {
            Log.alwaysError(this.getClass().getName(), "ERROR in copyAssetDirectory : " + iOException.toString());
        }
    }

    public static void deleteAllAssetsFromSDCard(File file, File file2) {
        try {
            if (file2 != null && file2.exists()) {
                if (file2.isDirectory()) {
                    for (String string : file2.list()) {
                        File file3 = new File(file2.getCanonicalPath() + "/" + string);
                        if (file3 != null && file3.delete()) continue;
                        Log.restricted(AssetCopier.class.getName(), "Error deleting file in " + file2.getCanonicalPath());
                    }
                }
                if (!file2.delete()) {
                    Log.restricted(AssetCopier.class.getName(), "Error deleting " + file2.getCanonicalPath());
                }
            }
            if (!file.delete()) {
                Log.restricted(AssetCopier.class.getName(), "Error deleting " + file.getCanonicalPath() + " (directory is probably not empty)");
            }
        }
        catch (Exception exception) {
            Log.restricted(AssetCopier.class.getName(), "Error managing data: " + exception.getMessage());
        }
    }
}

