package com.polestar.sensors;

import android.content.Context;
import android.content.ContextWrapper;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Looper;

import com.polestar.helpers.Log;
import com.polestar.models.ISensorListener;
import com.polestar.models.SensorNao;
import com.polestar.naosdk.api.TSENSORPOWERMODE;


public class MemsMagnetoSensor extends SensorNao{

	private static final String MEMS_MAGNETO_SENSOR_THREAD_NAME = "MS_Magneto_Thread"; // name of the thread MEMS
	/** The object to which this sensor sends its data when available */
	private ISensorListener mObserver;
	private MemsSensor mMemsSensor;
	private Sensor mSensor;
    /**
     * Constructor
     * @param caller, the context
     */
	public MemsMagnetoSensor(ContextWrapper caller,MemsSensor memsSensor) {
		super();
		mMemsSensor = memsSensor;
		SensorManager sensorManager = (SensorManager) caller.getSystemService(Context.SENSOR_SERVICE);
		mSensor = sensorManager.getDefaultSensor(Sensor.TYPE_MAGNETIC_FIELD);
		mThread = new Thread(this);
		mThread.setName(MEMS_MAGNETO_SENSOR_THREAD_NAME);
		mThread.start();

		if (caller == null) {
    		mStatus = STATUS_ERROR;
		}else{
			this.mCtxtWrap = caller;
			this.mStatus = STATUS_READY;
		}
	}
	
	/**
 	 *	thread run, MemsSensor is a thread
	 */
	public void run() {
		Looper.prepare();
		myLooper = Looper.myLooper();
		this.mOrder = ORDER_TURN_OFF;
        Looper.loop();
	}


	/**
	 * initMemsSensors
	 * initTimers
	 * state READY -> RUNNING or ERROR
	 */
	@Override
	public boolean startSensor() {
		if(mMemsSensor != null) {
			mMemsSensor.registerSensor(mSensor);
			this.mStatus = STATUS_RUNNING;
			this.mOrder = ORDER_TURN_ON;
		}
		return true;
	}

	/**
	 * Function called by sensor owner for the sensor to properly stop before it completely ceases functionning.
	 * The sensor cannot be used any more after this call. This effectively exits its thread main loop.
	 * Has no effect if status is not RUNNING
	 * cancelTimers
	 * finalizeMemsSensors
	 * state RUNNING -> READY
	 */
	@Override
	public void stopSensor() {
		if(mMemsSensor != null) {
			mMemsSensor.unregisterSensor(mSensor);
		}
	    this.mStatus = STATUS_READY;
	    this.mOrder = ORDER_TURN_OFF;
	}

	@Override
	public void start() {
		Log.alwaysWarn(this.getClass().getName(),"Starting Mems Magneto sensors from native .....");
		switchSensor(SensorNao.ORDER_TURN_ON, SensorNao.ORDER_PROVENANCE_SERVICE);
	}

	@Override
	public boolean isRunning() {
		return (mStatus == STATUS_RUNNING);
	}

	@Override
	public void stop() {
		Log.alwaysWarn(this.getClass().getName(),"Stoping Mems Magneto sensors from native .....");
		switchSensor(SensorNao.ORDER_TURN_OFF, SensorNao.ORDER_PROVENANCE_SERVICE);
	}

	/**
	 * stops and restarts the sensor thread
	 * has no effect if state is not RUNNING.
	 *
	 * WARNING : this method may take a few hundred milliseconds and even a few seconds, since it blocks until the
	 * sensor thread ('main' method) ends.
	 **/
	@Override
	public void reset() {
	    if (this.mStatus == STATUS_RUNNING && this.mOrder == ORDER_TURN_ON) {
	        switchSensor(ORDER_TURN_OFF,ORDER_PROVENANCE_SERVICE);
	        switchSensor(ORDER_TURN_ON,ORDER_PROVENANCE_SERVICE);
	    }
	}

	@Override
	public void setPowerMode(TSENSORPOWERMODE mode) {
		//Not implemented
	}

	@Override
	public void registerOutputInterface(ISensorListener targetInterface) {
		this.mObserver = targetInterface;
	}

	@Override
	public boolean isOn() {
		return (this.mStatus == STATUS_RUNNING);   
	}

	@Override
	public boolean hasFix() {
		return false;
	}

	@Override
	public boolean isActive() {
		return isHardwareCompatible();
	}
	
	/**
     * get if sensor is HW compatible
     */
	public boolean isHardwareCompatible() {

		return (mCtxtWrap.getSystemService(Context.SENSOR_SERVICE) != null); 
	}
	
	/**
	 * destructor : cleanly stops the service.
	 */
	protected void finalize() {
		stopSensor();
	}

	@Override
	public boolean setStateAsBefore() {
		// TODO Auto-generated method stub
		return false;
	}
	

}

