package com.polestar.sensors;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.RequiresApi;

import com.polestar.helpers.Log;
import com.polestar.naosdk.managers.NaoContext;
import com.polestar.naosdk.managers.NaoServiceManager;

/**
 * Created by jchouki on 02/02/2017.
 */
public class BleSensorTimeDownBroadcastReceiver extends BroadcastReceiver{
        @Override
        public void onReceive(Context context, Intent intent) {
            Log.alwaysWarn(this.getClass().getName(),"TimeDownBroadcastReceiver::onReceive ... " + context.getApplicationContext());

            if (android.os.Build.VERSION.SDK_INT < 18) {
                return;
            }
            BleSensor43 myBleSensor = (BleSensor43) NaoServiceManager.getService().getNaoContext().getSensorsManager().getBleSensor();
            if(myBleSensor != null) {
                myBleSensor.setIsTimeDown(false);
                myBleSensor.scheduleTimeUp();
                myBleSensor.resetBleScan();
            }
        }
}
