package com.polestar.naosync;

import android.content.ContextWrapper;
import android.os.Handler;

import com.polestar.naosdk.api.INAOSyncListener;
import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOSyncListener;


public class NAOSyncListenerWrapper extends INAOSyncListener {

    NAOSyncListener myListener;
    Handler mainHandler;

    public NAOSyncListenerWrapper(ContextWrapper context, String apiKey_, NAOSyncListener listener)
    {
        myListener = listener;
        mainHandler = new Handler(context.getApplicationContext().getMainLooper());
    }

    @Override
    public void onSyncSuccess(){

        Runnable myRunnable = new Runnable() {
            @Override
            public void run() {
                myListener.onSynchronizationSuccess();

            }
        };
        mainHandler.post(myRunnable);
    }

    @Override
    public void onSyncFailure(final NAOERRORCODE errorCode, final String msg)
    {
        Runnable myRunnable = new Runnable() {
            @Override
            public void run() {
                myListener.onSynchronizationFailure(errorCode, msg);
            }
        };
        mainHandler.post(myRunnable);
    }
}
