package com.polestar.naosdk.managers;

import android.content.Context;
import android.content.ContextWrapper;
import android.os.Handler;
import android.support.annotation.NonNull;

import com.polestar.helpers.AssetCopier;

import com.polestar.helpers.LocalPathHelper;
import com.polestar.helpers.Log;
import com.polestar.naosdk.api.INAOLocationClient;
import com.polestar.naosdk.api.INAOServiceProvider;
import com.polestar.naosdk.api.external.NAOBeaconProximityListener;
import com.polestar.naosdk.api.INAOProximityClient;
import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.api.external.NAOSyncListener;
import com.polestar.naosdk.api.external.TBEACONSTATE;
import com.polestar.naosdk.api.external.TPOWERMODE;
import com.polestar.naosync.NAOSyncListenerWrapper;

/**
 * Created by asimonigh on 15/01/2016.
 */
public class NAOBeaconProximityProvider extends INAOServiceProvider<NAOBeaconProximityListener, INAOProximityClient> {

    public NAOBeaconProximityProvider(Context context, Class<?> cls, @NonNull String apiKey, @NonNull NAOBeaconProximityListener client, @NonNull NAOSensorsListener sensorsListener) {
        super(context, cls, apiKey, client, sensorsListener);
    }

    @Override
    protected boolean registerClient() {
        return getServiceManager().registerProximityClient(mInternalClient, myApiKey, myISensorRequestListener);
    }

    @Override
    public void unregisterClient() {
        getServiceManager().unregisterProximityClient(mInternalClient);
    }

    @Override
    protected INAOProximityClient createInternalClient(){
        return this.new InternalClient();
    }

    private class InternalClient extends INAOProximityClient {

        @Override
        public void onProximityChange(final TBEACONSTATE state, final String label) {
            NAOBeaconProximityProvider.this.executeInHandler(new Runnable() {
                @Override
                public void run() {
                    myExternalListener.onProximityChange(state, label);
                }
            });
        }

        @Override
        public void onBeaconRange(final int rssi, final String label) {

            NAOBeaconProximityProvider.this.executeInHandler(new Runnable() {
                @Override
                public void run() {
                    myExternalListener.onBeaconRange(rssi, label);
                }
            });
        }


        @Override
        public void onError(final NAOERRORCODE code, final String msg) {
            Log.writeToLog(this.getClass().getName(), "onError code=" + code + " msg=" + msg);

            NAOBeaconProximityProvider.this.executeInHandler(new Runnable() {
                @Override
                public void run() {
                    myExternalListener.onError(code, msg);
                }
            });
        }

    }

    @Override
    protected void setPowerModeInternal(@NonNull TPOWERMODE mode) {
        getServiceManager().setBeaconProximityClientPowerMode(myPowerMode, mInternalClient);
    }


}
