package com.polestar.naosdk.managers;

import android.content.Context;
import android.content.ContextWrapper;
import android.os.Handler;
import android.support.annotation.NonNull;

import com.polestar.helpers.AssetCopier;
import com.polestar.helpers.LocalPathHelper;
import com.polestar.helpers.Log;

import com.polestar.naosdk.api.INAOAnalyticsClient;
import com.polestar.naosdk.api.INAOServiceProvider;
import com.polestar.naosdk.api.external.NAOAnalyticsListener;

import com.polestar.naosdk.api.external.NAOERRORCODE;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.api.external.NAOSyncListener;
import com.polestar.naosdk.api.external.TPOWERMODE;
import com.polestar.naosync.NAOSyncListenerWrapper;

import java.io.File;

/**
 * Created by asimonigh on 15/01/2016.
 */
public class NAOAnalyticsProvider extends INAOServiceProvider<NAOAnalyticsListener, INAOAnalyticsClient> {


    public NAOAnalyticsProvider(Context context, Class<?> cls, @NonNull String apiKey, @NonNull NAOAnalyticsListener client, @NonNull NAOSensorsListener sensorListener) {
        super(context, cls, apiKey, client, sensorListener);
    }

    @Override
    protected boolean registerClient() {
        return getServiceManager().registerAnalyticsClient(mInternalClient, myApiKey, myISensorRequestListener);
    }

    @Override
    public void unregisterClient() {
        getServiceManager().unregisterAnalyticsClient(mInternalClient);
    }

    @Override
    protected INAOAnalyticsClient createInternalClient(){
        return this.new InternalClient();
    }

    private class InternalClient extends INAOAnalyticsClient {

        @Override
        public void onError(final NAOERRORCODE code, final String msg) {
            Log.writeToLog(this.getClass().getName(), "onError code=" + code + " msg=" + msg);
            NAOAnalyticsProvider.this.executeInHandler(new Runnable() {
                @Override
                public void run() {
                    myExternalListener.onError(code, msg);
                }
            });
        }
    }

    @Override
    public void setPowerModeInternal(@NonNull TPOWERMODE mode) {
        getServiceManager().setAnalyticsClientPowerMode(myPowerMode, mInternalClient);
    }

}
