package com.polestar.naosdk.managers;

import android.content.ContextWrapper;
import android.os.Handler;

import com.polestar.naosdk.api.ISensorRequestListener;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.sensors.BleSensor;
import com.polestar.sensors.OSLocSensor;


/**
 * Created by jchouki on 20/01/2016.
 */
public class ISensorRequestListenerImpl extends ISensorRequestListener {
    private NAOSensorsListener listener;
    private Handler mainHandler;
    private ContextWrapper context;

    // thhe context should the one from the Service, the handler should be the one from the app
    public ISensorRequestListenerImpl(Handler maHandler, NAOSensorsListener myListener, ContextWrapper context) {
        this.mainHandler = maHandler;
        this.listener = myListener;
        this.context = context;
    }

    @Override
    public void onRequestedBle(String msg) {
            boolean locOSEnabled = OSLocSensor.checkLocationProviders(context);
            if (!locOSEnabled) {
            //always ask user for locOS to use our service
            onRequestedLocation(msg);
                            }

            //return if ble is already enabled
            if(BleSensor.isBleAvailable(context)) {
                return;
            }

        if (listener != null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if (listener != null) {
                        listener.requiresBLEOn();
                    }
                }
            };
            mainHandler.post(myRunnable);
        }
    }

    @Override
    public void onRequestedWifi(String msg) {

        boolean locOSEnabled = OSLocSensor.checkLocationProviders(context);
        if (!locOSEnabled) {
            //always ask user for locOS to use our service
            onRequestedLocation(msg);
        }

        if (listener != null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if (listener != null) {
                        listener.requiresWifiOn();
                    }
                }
            };
            mainHandler.post(myRunnable);
        }
    }

    @Override
    public void onRequestedLocation(String msg) {
        if (listener != null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if (listener != null) {
                        listener.requiresLocationOn();
                    }
                }
            };
            mainHandler.post(myRunnable);
        }
    }

    @Override
    public void onRequestedCompassCalibration(String msg) {
        if (listener != null) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    if (listener != null) {
                        listener.requiresCompassCalibration();
                    }
                }
            };
            mainHandler.post(myRunnable);
        }
    }

    @Override
    public void onLocationActivated() {
        // methode à ajouter à l'interface à implémenter par le client, ce qui rend la mise a jour non rétro compatible
    }

    @Override
    public void onBleActivated() {
        // methode à ajouter à l'interface à implémenter par le client, ce qui rend la mise a jour non rétro compatible
    }

    @Override
    public void onWifiActivated() {
        // methode à ajouter à l'interface à implémenter par le client, ce qui rend la mise a jour non rétro compatible
    }

    @Override
    public void onCompassCalibrated() {
        // methode à ajouter à l'interface à implémenter par le client, ce qui rend la mise a jour non rétro compatible
    }
}
