package com.polestar.naosdk.fota.service;

import android.app.Activity;
import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;

import com.polestar.helpers.Log;
import com.polestar.helpers.UI.UIHelper;
import com.polestar.naosdk.api.ICrashLogHelper;
import com.polestar.naosdk.api.external.NAOSensorsListener;
import com.polestar.naosdk.fota.BLESettings;
import com.polestar.naosdk.fota.Beacon;
import com.polestar.naosdk.fota.BeaconConfMission;
import com.polestar.naosdk.fota.BeaconConfiguration;
import com.polestar.naosdk.fota.BeaconState;
import com.polestar.naosdk.fota.BluespotVersion;
import com.polestar.naosdk.fota.IBeaconConfListener;
import com.polestar.naosdk.fota.MissionState;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by asimonigh on 12/05/2017.
 */

@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR2)
public class NAOBeaconConfService extends Service{

    private BeaconConfClient nativeClient ;
    private boolean isRegisteredToNative = false;
    private Handler myHandler;

    private ICrashLogHelper crashLogHelper = new ICrashLogHelper() {
        @Override
        public void log(String msg) {

        }

        @Override
        public void setString(String key, String value) {

        }

        @Override
        public void setInt(String key, int value) {

        }

        @Override
        public void setFloat(String key, float value) {

        }

        @Override
        public void setBool(String key, boolean value) {

        }

        @Override
        public void setUserIdentifier(String identifier) {

        }
    };

    // Binder given to the clients
    private final IBinder mBinder = new BeaconConfigBinder();

    //observers ( clients )
    private ArrayList<BeaconConfServiceListener> clientsObservers = new ArrayList<>();

    @Override
    public void onCreate() {
        super.onCreate();

        myHandler = new Handler(this.getApplicationContext().getMainLooper());
    }

    @Override
    public void onDestroy() {
        if(null !=  nativeClient){
            nativeClient.unregisterClient();
            isRegisteredToNative = false;
            Log.alwaysWarn(getClass().getSimpleName(), "Service stopped");
        }
        Log.alwaysWarn(getClass().getSimpleName(), "Service stopped");
    }


    public void resgisterNativeClient(Activity view, String deploymentID, String token, int siteID, String cloudURL, NAOSensorsListener sensorsListener){
        if(isRegisteredToNative){
            Log.alwaysWarn(getClass().getSimpleName(), "Client already registered !");
            return;
        }
        //TODO: add crashloghelper


        nativeClient = new BeaconConfClient(this, siteID, cloudURL, token, new UIHelper(view), crashLogHelper, nativeConfListener);
        nativeClient.registerClient(deploymentID, sensorsListener);
    }

    public boolean isClientInitialized(){
        return nativeClient != null ;
    }

    public void downloadMissions(){
        nativeClient.downloadMissions();
    }

    public void startMission(final int missionID, final boolean restart){
     new Thread(new Runnable() {
         @Override
         public void run() {
             nativeClient.startMission(missionID, restart);
         }
     }).start();

    }

    public void stopMission(){
        new Thread(new Runnable() {
            @Override
            public void run() {
                nativeClient.stopMission();
            }
        }).start();
    }

    public void synchronizeConfiguration(Beacon beacon, BeaconConfiguration configuration, BLESettings settings){
        nativeClient.synchroConfiguration(beacon, configuration, settings);
    }
    public MissionState getMissionState(int id){
        return nativeClient.getMissionState(id);
    }

    public void sendReports(){
        nativeClient.sendMissionReports();
    }

    public void setBLESettings(BLESettings settings){
        nativeClient.setBleSettings(settings);
    }

    public BLESettings getBLESettings(){
        return nativeClient.getBleSettings();
    }

    public List<Beacon> getBeaconsFromMission(int missionID){
        return nativeClient.getBeaconsFromMission(missionID);
    }

    public BeaconState getBeaconState(int missionID, int beaconID){
        return  nativeClient.getBeaconStatre(missionID, beaconID);
    }

    public BeaconConfiguration getConfigurationFromBeacon(int missionID, int beaconID){
        return nativeClient.getBeaconConf(beaconID, missionID);
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return mBinder;
    }


    private IBeaconConfListener nativeConfListener = new IBeaconConfListener() {
        @Override
        public void onMissionsFound(final ArrayList<BeaconConfMission> missionsFound) {
            Runnable myRunnable = new Runnable() {
				@Override
				public void run() {
                    for(BeaconConfServiceListener client : clientsObservers){
                        client.onMissionsFound(missionsFound);
                    }
				}
			};
			myHandler.post(myRunnable);

        }

        @Override
        public void onMissionStateChanged(final int missionID, final MissionState state) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    for(BeaconConfServiceListener client : clientsObservers){
                        client.onMissionStateChanged(missionID, state);
                    }
                }
            };
            myHandler.post(myRunnable);

        }

        @Override
        public void onBeaconStateChanged(final int beaconID, final BeaconState state) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    for(BeaconConfServiceListener client : clientsObservers){
                        client.onBeaconStateChanged(beaconID, state);
                    }
                }
            };
            myHandler.post(myRunnable);

        }

        @Override
        public void onBeaconFlashLostDetected(final int beaconID) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    for(BeaconConfServiceListener client : clientsObservers){
                        client.onBeaconFlashLost(beaconID);
                    }
                }
            };
            myHandler.post(myRunnable);
        }

        @Override
        public void onBeaconsSeen(final int nbSeen) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    for(BeaconConfServiceListener client : clientsObservers){
                        client.onBeaconsSeen(nbSeen);
                    }
                }
            };
            myHandler.post(myRunnable);
        }

        @Override
        public void onBeaconVersionFound(final int beaconID, final BluespotVersion version) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    for(BeaconConfServiceListener client : clientsObservers){
                        client.onBeaconVersion(beaconID, version);
                    }
                }
            };
            myHandler.post(myRunnable);
        }

        @Override
        public void onBeaconRSSIChanged(final int beaconID, final int rssi) {
            Runnable myRunnable = new Runnable() {
                @Override
                public void run() {
                    for(BeaconConfServiceListener client : clientsObservers){
                        client.onBeaconRssiChanged(beaconID, rssi);
                    }
                }
            };
            myHandler.post(myRunnable);
        }


    };

    //Interface implemented by client
    public interface BeaconConfServiceListener {

        void onMissionsFound(List<BeaconConfMission> missions);
        void onMissionStateChanged(int missionID, MissionState state);
        void onBeaconStateChanged(int beaconID, BeaconState state);
        void onBeaconFlashLost(int beaconID);
        void onBeaconVersion(int beaconID, BluespotVersion version);
        void onBeaconsSeen(int nbSeen);
        void onBeaconRssiChanged(int beaconID, int rssi);
    }

    //Class used for the client binder
    public class BeaconConfigBinder extends Binder {
        public NAOBeaconConfService getService(){
            return NAOBeaconConfService.this;
        }

        public void addObserver(NAOBeaconConfService.BeaconConfServiceListener observer){
            clientsObservers.add(observer);
        }

        public void removerObserver(NAOBeaconConfService.BeaconConfServiceListener observer){
            clientsObservers.remove(observer);
        }
    }


}
