package com.polestar.naosdk.api.external;

/**
 * Service input files synchronization callbacks
 */
public interface NAOSyncListener {

    /**
     * called on synchronization success
     */
    void onSynchronizationSuccess();

    /**
     * Receives notification when an error occured during the synchronization process
     * @param errorCode error code. Check NAOERRORCODE doc for a description of error codes.
     * @param message message providing extra information about the error.
     */
    void onSynchronizationFailure(NAOERRORCODE errorCode, String message);
}
